// Helper functions...

function setGravity(%player, %spawnobj)
{
   %rotation = getWords(%spawnobj.getTransform(), 3);
   %ortho = vectorOrthoBasis(%rotation);
   %orthoinv = getWords(%ortho, 0, 5) SPC VectorScale(getWords(%ortho, 6), -1);
   %player.setGravityDir(%orthoinv,true);
}

function restartLevel()
{
   if( isObject( LocalClientConnection.checkPointShape ) )
      LocalClientConnection.checkPointShape.stopThread( 0 );
   
   LocalClientConnection.checkPoint = 0;
   LocalClientConnection.checkPointPowerUp = 0;
   LocalClientConnection.checkPointShape = 0;
   LocalClientConnection.CheckPointGemCount = 0;
   LocalClientConnection.checkPointBlastEnergy = 0.0;
   LocalClientConnection.checkPointGemConfirm = 0;
   LocalClientConnection.respawnPlayer();
}


function endFinishPoint()
{
   cancel($finishPointSchedule);
   
   // Rank the players
   buildRanks();

   setGameState("end");
}

function doRankNotifications()
{
   if (!isObject(PlayersRanks))
   {
      error("PlayersRanks does not exist, can't do rank notifications");
      return;
   }
   
   if (PlayersRanks.rowCount() == 0)
   {
      error("PlayersRanks has no rows, can't do rank notifications");
      return;
   }
   
   // assume the ranks are sorted in descending order
   // get the name of the leader
   %leader = PlayersRanks.getRowId(0);
   // %leader is a client Id (game connection object)
   %leaderName = %leader.name;
   %leaderPoints = %leader.points;
   
   for ( %clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++ )
   {
      %cl = ClientGroup.getObject( %clientIndex );
      %rank = PlayersRanks.getRowTextById(%cl);
      
      if (%rank == PlayersRanks.rowCount() - 1)
      {
         %cl.player.setMode(Victory);
         //if ($tied)
         //   messageClient(%cl, 'MsgRaceOver', $Text::Tagged::TiedMP );
         //else
         //   messageClient(%cl, 'MsgRaceOver', $Text::Tagged::WonMP );
         %cl.play2D(WonRaceSfx);
      }
      else
      {
         %cl.player.setMode(Lost);
         //messageClient(%cl, 'MsgRaceOver', $Text::Tagged::YouLost );
         %cl.play2D(LostRaceSfx);
      }
      messageClient(%cl, 'MsgMPGameOver', "", $tied, %leaderName, %leaderPoints );
   }
}

function getRandomObject(%groupName)
{
   %group = nameToID(%groupName);

   %object = 0;
   
   if (%group != -1)
   {
      %count = %group.getCount();

      if (%count > 0)
      {
         %index = getRandom(%count - 1);
         %object = %group.getObject(%index);
      }
   }
   return %object;
}