//-----------------------------------------------------------------------------
// Manage game state
//-----------------------------------------------------------------------------

// This is used to inform all of the clients that the
// server is in a "wait" state
function setWaitState(%client)
{
   commandToClient(%client, 'setGemCount', 0, $Game::GemCount);
   commandToClient(%client, 'setTimer', "reset");
   commandToClient(%client, 'setMessage', "");
   commandToClient(%client, 'setGameDuration', 0, 0);
}

// This is used to inform all of the clients that the
// server is in a "start" state
function setStartState(%client)
{
   commandToClient(%client, 'setGemCount', 0, $Game::GemCount);
   %help = MissionInfo.startHelpText;
   if (%help !$= "")
      commandToClient(%client, 'setHelpLine', %help);
   commandToClient(%client, 'setMessage',"");

   commandToClient(%client, 'setTimer', "reset");
   if ($Game::Duration)
      commandToClient(%client, 'setGameDuration', $Game::Duration, 0);
   
   if (isObject($timeKeeper) && %client == $timeKeeper)
      %client.player.setMarbleTime(0);
   else if (isObject($timeKeeper))
      %client.player.setMarbleTime($timeKeeper.player.getMarbleTime());

   %client.player.setMode(Start);
}

// This is used to inform all of the clients that the
// server is in a "ready" state
function setReadyState(%client)
{
   commandToClient(%client, 'setMessage', "ready");
   if ($Game::Duration)
      commandToClient(%client, 'setGameDuration', $Game::Duration, 0);
   //%this.play2D(ReadyVoiceSfx);

   // Sync with the "first" marble
   if (isObject($timeKeeper) && %client != $timeKeeper)
      %client.player.setMarbleTime($timeKeeper.player.getMarbleTime());
}

// This is used to inform all of the clients that the
// server is in a "set" state
function setSetState(%client)
{
   commandToClient(%client, 'setMessage', "set");
   //%this.play2D(SetVoiceSfx);

   // Sync with the "first" marble
   if (isObject($timeKeeper) && %client != $timeKeeper)
      %client.player.setMarbleTime($timeKeeper.player.getMarbleTime());
}

// This is used to inform all of the clients that the
// server is in a "go" state
function setGoState(%client)
{
   commandToClient(%client, 'setMessage', "go");
   //%this.play2D(GetRollingVoiceSfx);
   commandToClient(%client, 'setTimer', "start");
   if ($Game::Duration)
      commandToClient(%client, 'setGameDuration', $Game::Duration, 0);

   if (MissionInfo.gameType $= "SinglePlayer")
      %client.player.setPad($Game::EndPad);

   %client.player.setMode(Normal);

   // Sync with the "first" marble
   if (isObject($timeKeeper) && %client != $timeKeeper)
      %client.player.setMarbleTime($timeKeeper.player.getMarbleTime());
}

// This is used to inform all of the clients that the
// server is in a "play" state
function setPlayState(%client)
{
   commandToClient(%client, 'setMessage', "");

   if ($Game::Duration)
      commandToClient(%client, 'setGameDuration', $Game::Duration, $Server::PlayStart);

   // Sync with the "first" marble
   if (isObject($timeKeeper) && %client != $timeKeeper)
      %client.player.setMarbleTime($timeKeeper.player.getMarbleTime());
}

// This is used to inform all of the clients that the
// server is in a "end" state
function setEndState(%client, %winner)
{
   commandToClient(%client, 'setTimer', "stop");
   commandToClient(%client, 'setEndTime', $Server::PlayEnd);
}

// The server maintains the state and transitions to other states
function setGameState(%state)
{
   // Skip out of the current transitions
   if (isEventPending($stateSchedule))
      cancel($stateSchedule);

   $stateSchedule = 0;
   
   if (%state $= "play")
      $Server::PlayStart = getSimTime();
   if (%state $= "end")
      $Server::PlayEnd = getSimTime();

   // Update client states
   for (%clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++)
   {
      %cl = ClientGroup.getObject( %clientIndex );

      switch$ (%state)
      {
         case "wait"  :
            setWaitState(%cl);
         case "start" :
            setStartState(%cl);
         case "ready" :
            setReadyState(%cl);
         case "go"    :
            setGoState(%cl);
         case "play"  :
            setPlayState(%cl);
         case "end"   :
            setEndState(%cl);
      }

      commandToClient(%cl, 'setGameState', %state);
   }

   // schedule the transition to the next state
   switch$ (%state)
   {
      case "start" :
         $stateSchedule = schedule(500, 0, "setGameState", "ready");
      case "ready" :
         $stateSchedule = schedule(3000, 0, "setGameState", "go");
//      case "set"   :
//         $stateSchedule = schedule(1500, 0, "setGameState", "go");
      case "go"    :
         $stateSchedule = schedule(2000, 0, "setGameState", "play");
         if ($Game::Duration)
         {
            $Game::CycleSchedule = schedule($Game::Duration + 90, 0, "onGameDurationEnd" );
            if ($Server::ServerType $= "MultiPlayer")
            {
               // block join in progress in last minute in all games.  it may be already blocked
               // (e.g. in ranked games)
               %blockAt = $Game::Duration - 60 * 1000;
               if (%blockAt > 0)
               {
                  $Game::BlockJIPSchedule = schedule(%blockAt, 0, "serverSetJIPEnabled", false);
               }  
            }
         }
      case "end"   :
         $stateSchedule = schedule( 5000, 0, "endGame");
   }
   
   $Game::State = %state;
}