//-----------------------------------------------------------------------------
// Handle a player going out-of-bounds
//-----------------------------------------------------------------------------
function GameConnection::onOutOfBounds(%this)
{
   if ($Game::State $= "End" || $Game::State $= "wait")
      return;

   // Reset the player back to the last checkpoint
   commandToClient(%this,'setMessage',"outOfBounds",2000);
   %this.play2d(OutOfBoundsVoiceSfx);
   %this.player.setOOB(true);
   if(!isEventPending(%this.respawnSchedule))
      %this.respawnSchedule = %this.schedule(2500, respawnPlayer);
}

//-----------------------------------------------------------------------------
// Respawn an existing player
//-----------------------------------------------------------------------------
function GameConnection::respawnPlayer(%this)
{
   // Reset the player back to the last checkpoint
   cancel(%this.respawnSchedule);
   
   // clear any messages being displayed to client
   commandToClient(%this, 'setMessage',"");

   if ($Server::ServerType $= "SinglePlayer")
   {
      // if the player has no checkpoint, assume a full mission restart is occuring
      if (!isObject(%this.checkPoint))
      {
         onMissionReset();
         setGameState("start");
         %this.player.setMode(Start);
         %this.player.setMarbleTime(0);
         %this.gemCount = 0;
         commandToClient(%this, 'setGemCount', %this.gemCount, $Game::GemCount);
      }
      else
      {
         // Reset the moving platforms ONLY
         if( isObject( ServerGroup ) )
            ServerGroup.onMissionReset( %this.checkPointGemConfirm );
         
         // This animation is fucked up -pw
         //%this.checkPointShape.stopThread( 1 );
         //%this.checkPointShape.schedule( 200, "playThread", 1, "respawn" );
         %this.gemCount = %this.checkPointGemCount;
         commandToClient(%this, 'setGemCount', %this.gemCount, $Game::GemCount);
         
         %this.player.setBlastEnergy( %this.checkPointBlastEnergy );
      }
   }
   
   %this.player.setMarbleBonusTime(0);
   
   %powerUp = %this.player.getPowerUp();
   %this.player.setPowerUp(0, true);
   if ($Server::ServerType $= "MultiPlayer")
      %this.player.setPowerUp(%powerUp);
   else if( $Server::ServerType $= "SinglePlayer" && isObject( %this.checkPoint ) && isObject( %this.checkPointPowerUp ) )
      %this.player.setPowerUp( %this.checkPointPowerUp );

   %this.player.setOOB(false);
   %this.player.setVelocity("0 0 0");
   %this.player.setVelocityRot("0 0 0");
   
   if (($Server::ServerType $= "SinglePlayer" || MissionInfo.gameMode $= "Race") && isObject(%this.checkPoint))
   {
      // Check and if there is a checkpoint shape, use that instead so the marble gets centered
      // on it properly. Mantis bug: 0000819
      if( isObject( %this.checkPointShape ) )
         %spawnPoint = %this.checkPointShape;
      else
         %spawnPoint = %this.checkPoint;
   }
   else
   {
      // in multiplayer mode, try to use the spawn point closest to the 
      // marble's last contact position.  if this position is invalid 
      // the findClosest function will defer to pickSpawnPoint()
      if ($Server::ServerType $= "MultiPlayer")
         %spawnPoint = findClosestSpawnPoint(%this.player.getLastContactPosition());
      else
      {
         // If we restarted the level, reset the blast energy
         %this.player.setBlastEnergy( 0.0 );
         
         %spawnPoint = pickPlayerSpawnPoint($Game::DefaultPlayerSpawnGroups);
      }
   }

   %spawnPos = getSpawnPosition(%spawnPoint);
   
   %this.player.setPosition(%spawnPos, 0.45);
   setGravity(%this.player, %spawnPoint);
   
   faceGems( %this.player );
   
   serverPlay3d(spawnSfx, %this.player.getTransform());
}

//-----------------------------------------------------------------------------
// Found a gem
//-----------------------------------------------------------------------------
function GameConnection::onFoundGem(%this,%amount,%gem,%points)
{
   if (MissionInfo.gameMode $= "Scrum")
   {
      %gem.deleted = true;

      schedule(0, 0, "removeGem", %gem);

      %oldPoints = %this.points;
      %this.points += %points;

      // send message to client telling him he scored (true parameter means msg recipient is scoring client)
      %this.play2D(GotGemSfx);
      %count = ClientGroup.getCount();
      for(%cl= 0; %cl < %count; %cl++)
      {
         %recipient = ClientGroup.getObject(%cl);
         if(%recipient != %this)
            %recipient.play3D(OpponentGotGemSfx, %this.getControlObject().getTransform());
      }
      
      messageClient(%this, 'MsgClientScoreChanged', "", %this, true, %this.points, %oldPoints);
      // send message to everybody except client telling them that he scored
      messageAllExcept(%this, -1, 'MsgClientScoreChanged', "", %this, false, %this.points, %oldPoints);
      
      //commandToClient(%this, 'setPoints', %this, %this.points);
      //if (%points == 1)
      //   messageClient(%this, 'MsgItemPickup', $Text::Tagged::GemPickupOnePoint);
      //else
      //   messageClient(%this, 'MsgItemPickup', $Text::Tagged::GemPickupNPoints, %points);

      return;
   }

   $Game::GemsFound += %amount;
   %this.gemCount += %amount;

   if (MissionInfo.gameMode $= "Hunt")
      %remaining = $Game::gemCount - $Game::GemsFound;
   else
      %remaining = $Game::gemCount - %this.gemCount;

   if (%remaining <= 0) {
      if (MissionInfo.gameType $= "Multiplayer")
      {
         // Rank the players
         buildRanks();

         doRankNotifications();
         
         setGameState("end");
      }
      else
      {
         messageClient(%this, 'MsgHaveAllGems', $Text::Tagged::HaveAllGems );
         %this.play2d(GotAllGemsSfx);
         %this.gemCount = $Game::GemCount;
      }
   }
   else
   {
      if(%remaining == 1)
         %msg = $Text::Tagged::OneGemLeft;
      else
         %msg = $Text::Tagged::NGemsLeft;

      messageClient(%this, 'MsgItemPickup', %msg, %remaining);
      %this.play2d(GotGemSfx);
   }
   
   // If we are in single player mode, keep track of the gems we have found
   // with regard to checkpoint status so you can't cheat with checkpoints
   if( MissionInfo.gameType $= "Singleplayer" && isObject( %this.checkPoint ) )
   {
      %gem.checkPointConfirmationNumber = %this.checkPointGemConfirm + 1;
   }

   commandToClient(%this,'setGemCount',%this.gemCount,$Game::GemCount);
}

//-----------------------------------------------------------------------------
// Assign a checkpoint to a marble
//-----------------------------------------------------------------------------
function GameConnection::setCheckpoint(%this, %checkPoint)
{
   // The CheckPoint triggers should have a sequence field that can
   // help us keep them in order
   if (%checkPoint.sequence >= %this.checkPoint.sequence && gravityIsEqual( %this.player, %checkpoint ) )
   {
      %this.checkPointGemConfirm++;
      //echo("checkpoint: " @ %this.checkPointGemConfirm);
      
      %sameOne = %checkPoint == %this.checkPoint;
      %this.checkPoint = %checkPoint;
      %this.checkPointPowerUp = %this.player.getPowerUp();
      %this.checkPointGemCount = %this.gemCount;
      %this.checkPointBlastEnergy = %this.player.getBlastEnergy();

      if (!%sameOne)
      {
         %chkGrp = %checkPoint.getGroup();
         
         for(%i = 0; ( %chkShape = %chkGrp.getObject( %i ) ) != -1; %i++ )
         {
            // This looks wonkey, however "checkpointShape" is the name of the datablock which
            // the shapes use. -pw
            if( %chkShape.getClassName() $= "StaticShape" && %chkShape.getDatablock().getId() == checkpointShape.getId() )
            {
               if( isObject( %this.checkPointShape ) )
                  %this.checkPointShape.stopThread( 0 );
               
               %this.checkPointShape = %chkShape;
               break;
            }
         }
   
         serverplay2d(CheckpointSfx);
         %this.checkPointShape.stopThread( 0 );
         %this.checkPointShape.playThread( 0, "activate" );
         commandToClient(%this, 'CheckpointHit', %checkPoint.sequence );
      }
   }
}

function GameConnection::onClientEnterGame(%this)
{
   // Find a spawn point for the camera
   %cameraSpawnPoint = pickCameraSpawnPoint($Game::DefaultCameraSpawnGroups);
   // Spawn a camera for this client using the found %spawnPoint
   %this.spawnCamera(%cameraSpawnPoint);
   
   // Set up initial game state for client
   if ($Game::State $= "wait")
   {
      // all clients enter wait state when joining
      %this.enterWaitState();
   }
   else
   {
      %this.onClientJoinGame();
      if ($Game::Running)
         commandToClient(%this, 'GameStart');
   }
   
   %this.resetStats();
   
   // tell the client whether we are in the lobby   
   messageClient(%this, 'MsgClientUpdateLobbyStatus', "", serverIsInLobby() );
   
   // tell him his score 
   messageClient(%this, 'MsgClientScoreChanged', "", %this, true, %this.points, %this.points);
   // tell him about everyone else's score
   for ( %clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++ )
   {
      %cl = ClientGroup.getObject( %clientIndex );
      if (%cl == %this)
         continue;
         
      messageClient(%this, 'MsgClientScoreChanged', "", %cl, false, %cl.points, %cl.points);
   }
   
   // And now join the client to the game
   %this.onClientJoinGame();
}


function GameConnection::onClientJoinGame(%this)
{
   // If we don't have a player object then create one
   if (!isObject(%this.player))
   {
      // Find a spawn point for the player
      %playerSpawnPoint = pickPlayerSpawnPoint($Game::DefaultPlayerSpawnGroups);
      // Spawn a camera for this client using the found %spawnPoint
      %this.spawnPlayer(%playerSpawnPoint);
   }

   // If this is the first client to join then start the game
   // Otherwise catchthis client up to the current game state
   if ($Game::State $= "wait")
   {
      // Start the game now
      startGame();

      // Start the game state machine
      setGameState("start");

      // Flag this client as the time keeper
      $timeKeeper = %this;
   }
   else
      %this.updateGameState();

   updateAvgPlayerCount();
   
   faceGems( %this.player );
   
   // keep Lobby status updated   
   messageClient(%this, 'MsgClientUpdateLobbyStatus', "", serverIsInLobby() );
}

// Set a client into the wait state
function GameConnection::enterWaitState(%this)
{
   %spawnPoint = pickSpawnPoint();
   %spawnPos = getSpawnPosition(%spawnPoint);
   
   if (isSinglePlayerMode())
   {
      if (!isObject($previewCamera))
      {
         $previewCamera = new Camera() {
            datablock = Observer;
         };
         
         // Make sure our $previewCamera doesn't end up in MissionCleanup
         if (isObject(MegaServerGroup))
            MegaServerGroup.add( $previewCamera );
         else
            ServerGroup.add( $previewCamera );
      }
      
      %this.camera = $previewCamera;
   }

   if (!isObject(%this.camera))
   {
      // Create a new camera object.
      %this.camera = new Camera() {
         dataBlock = Observer;
      };
      MissionCleanup.add( %this.camera );
      %this.camera.scopeToClient(%this);
   }
   
   %this.camera.setTransform(%spawnPos);
   %this.setControlObject(%this.camera);
   
   // smoke the player
   if (isObject(%this.player))
      %this.player.delete();
   %this.player = 0;
}


function GameConnection::onClientLeaveGame(%this)
{
   // Check to see if we need to set a new $timeKeeper
   if (%this == $timeKeeper && ClientGroup.getCount() > 1)
   {
      // Find a new $timeKeeper
      for ( %clientIndex = 0; %clientIndex < ClientGroup.getCount(); %clientIndex++ )
      {
         %cl = ClientGroup.getObject( %clientIndex );
         if (%cl != %this)
         {
            $timeKeeper = %cl;
            break;
         }
      }
   }

   if (isObject(%this.camera) && %this.camera != $previewCamera)
      %this.camera.delete();
   if (isObject(%this.player))
      %this.player.delete();
   %this.camera = 0;
   %this.player = 0;

   // update average player count, but need to temporarily dec player
   // count (because count doesn't get decremented till later)
   $Server::PlayerCount--;
   updateAvgPlayerCount();
   $Server::PlayerCount++;
}

function GameConnection::resetStats(%this)
{
   // Reset game stats
   %this.gemCount = 0;
   %this.points = 0;
   %this.rank = 0;
   %this.finishTime = 0;
   if (isObject(%this.player) && $Server::ServerType $= "SinglePlayer")
      %this.player.setMarbleTime(0);

   // Reset the checkpoint, except in single player modes
   if ($Server::ServerType !$= "SinglePlayer" && isObject(%this.checkPoint))
   {
      %this.checkPoint = 0;
      %this.checkPointPowerUp = 0;
      %this.checkPointShape = 0;
      %this.checkPointGemCount = 0;
      %this.checkPointBlastEnergy = 0.0;
      %this.checkPointGemConfirm = 0;
   }
}

//-----------------------------------------------------------------------------
// This is used to "catch up" newly joining clients
//-----------------------------------------------------------------------------
function GameConnection::updateGameState(%this)
{
   switch$ ($Game::State)
   {
      case "wait"  :
         setWaitState(%this);
      case "start" :
         setStartState(%this);
      case "ready" :
         setReadyState(%this);
      case "set"   :
         setSetState(%this);
      case "go"    :
         setGoState(%this);
      case "play"  :
         setPlayState(%this);
      case "end"   :
         setEndState(%this);
   }

   commandToClient(%this, 'setGameState', $Game::State);
}



//-----------------------------------------------------------------------------
// Single player methods
//-----------------------------------------------------------------------------
function GameConnection::incPenaltyTime(%this,%dt)
{
   %this.penaltyTime += %dt;
}

function GameConnection::incBonusTime(%this,%dt)
{
   %this.player.setMarbleBonusTime(%this.player.getMarbleBonusTime() + %dt);
}

function GameConnection::onEnterPad(%this)
{
   // Handle level ending
   if (MissionInfo.gameType $= "SinglePlayer")
   {
      if (%this.player.getPad() == $Game::EndPad) {

         if ($Game::GemCount && %this.gemCount < $Game::GemCount) {
            %this.play2d(MissingGemsSfx);
            messageClient(%this, 'MsgMissingGems', $Text::Tagged::NotAllGems );
         }
         else
         {
            %this.player.setMode(Victory);
            messageClient(%this, 'MsgRaceOver', $Text::Tagged::Congratulations );
            serverplay2d(WonRaceSfx);
            setGameState("end");
         }
      }
   }
}

function GameConnection::onLeavePad(%this)
{
   // Don't care if the leave
}

function GameConnection::onFinishPoint(%this)
{
   error("onFinishPoint called, but shouldn't be?  (Race mode only");
   
   // Freeze the player
   %this.player.setMode(Victory);

   // Grab the marble time (which should stop when the mode is set to Victory)
   %this.finishTime = %this.player.getMarbleTime();

   // A new person finished
   $Game::ClientsFinished++;

   // If this is the first person to finish set a timer to end the whole race
   if (!isEventPending($finishPointSchedule))
      $finishPointSchedule = schedule(10000, 0, "endFinishPoint");

   // Notify them of what palce they came in
//   if ($Game::ClientsFinished == 1)
//      %msg = $Text::Tagged::WonMP;
//   else if ($Game::ClientsFinished == 2)
//      %msg = $Text::Tagged::SecondMP;
//   else if ($Game::ClientsFinished == 3)
//      %msg = $Text::Tagged::ThirdMP;
//   else
//      %msg = $Text::Tagged::NthMP;

   // JMQ: we aren't using race mode anymore so just send down "game over"
   %msg = $Text::Tagged::GameOver;
   messageClient(%this, 'MsgFinish', %msg, $Game::ClientsFinished);

   // If everyone has finished end the game
   if ($Game::ClientsFinished >= ClientGroup.getCount())
      endFinishPoint();
}