//-----------------------------------------------------------------------------
// Torque Game Engine
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// PlayGui is the main TSControl through which the game is viewed.
// The PlayGui also contains the hud controls.
//-----------------------------------------------------------------------------

function PlayGui::onWake(%this)
{
   // Turn off any shell sounds...
   // sfxStop( ... );

   // just update the action map here
   moveMap.push();

   // hack city - these controls are floating around and need to be clamped
   schedule(0, 0, "refreshCenterTextCtrl");
   schedule(0, 0, "refreshBottomTextCtrl");
}

function PlayGui::onSleep(%this)
{
   // pop the keymaps
   moveMap.pop();
}

function PlayGui::clearHud( %this )
{
   while ( %this.getCount() > 0 )
      %this.getObject( 0 ).delete();
}

function PlayGui::updateTimer(%this, %time, %bonusTime)
{
   // TODO: Convert to SFX
   if (%bonusTime && $BonusSfx $= "")
   {
      $BonusSfx = alxPlay(TimeTravelLoopSfx);
   }
   else if (%bonusTime == 0 && $BonusSfx !$= "")
   {
      alxStop($BonusSfx);
      $BonusSfx = "";
   }

   %this.elapsedTime = %time;

   // Some sanity checking
   if (%this.elapsedTime > 3600000)
      %this.elapsedTime = 3599999;
      
   // TODO: Re-enable HUD GUI controls once supporting assets are in
   //%this.updateControls();
}   
function PlayGui::updateControls(%this)
{
   if (PlayGui.gameDuration)
      %et = PlayGui.gameDuration - %this.elapsedTime;
   else
      %et = %this.elapsedTime;
   %drawNeg = false;
   if(%et < 0)
   {
      %et = - %et;
      %drawNeg = true;
   }
   %hundredth = mFloor((%et % 1000) / 10);
   %totalSeconds = mFloor(%et / 1000);
   %seconds = %totalSeconds % 60;
   %minutes = (%totalSeconds - %seconds) / 60;
   %secondsOne      = %seconds % 10;
   %secondsTen      = (%seconds - %secondsOne) / 10;
   %minutesOne      = %minutes % 10;
   %minutesTen      = (%minutes - %minutesOne) / 10;
   %hundredthOne    = %hundredth % 10; 
   %hundredthTen    = (%hundredth - %hundredthOne) / 10;
   // Update the controls
   Min_Ten.setNumber(%minutesTen);
   Min_One.setNumber(%minutesOne);
   Sec_Ten.setNumber(%secondsTen);
   Sec_One.setNumber(%secondsOne);
   Sec_Tenth.setNumber(%hundredthTen);
   Sec_Hundredth.setNumber(%hundredthOne);
   PG_NegSign.setVisible(%drawNeg);
   
   if (%this.lastHundredth != %hundredth) 
   {
   	TimeBox.animBitmap("timebackdrop");
   	%this.lastHundredth = %hundredth;
	}
}
//-----------------------------------------------------------------------------

function refreshBottomTextCtrl()
{
   BottomPrintText.position = "0 0";
}

function refreshCenterTextCtrl()
{
   CenterPrintText.position = "0 0";
}
