// A new power-up is assigned to this client
function clientCmdSetPowerup(%shapeFile)
{
   // 
   PlayGui.setPowerUp(%shapeFile);
}

// Client-side collision routine 
function MarbleData::onClientCollision(%this,%obj,%col)
{
   // JMQ: workaround: skip hidden objects  
   if (%col.isHidden())
      return;
      
   // Try and pickup all items
   if (%col.getClassName() !$= "Item")
      return;

   %data = %col.getDatablock();

   if (%data.getName() $= "GemItem")
   {
      // it's a gem, simply hide the gem and leave, let the server
      // play sounds and update our gem count
      %col.setClientHidden($Game::clientHiddenTime);
      return;
   }

   if (strstr(%data.shapeFile,"ravity.dts") != -1)
   {
      // Must be the anti-gravity powerup (searched for
      // "ravity" in order to avoid potential caps issues).
      %rotation = getWords(%col.getTransform(),3);
      %ortho = vectorOrthoBasis(%rotation);
      %down = getWords(%ortho,6);
      if (VectorDot(%obj.getGravityDir(),%down)>0.9)
         // Don't pick up if same as current gravity:
         return;
      %obj.setGravityDir(%ortho);
   }

   if (%data.powerupId && (%data.powerUpId == %obj.getPowerUpId()))
   {
      // already have this powerup...don't pick up
      return;
   }

   // hide the powerup
   if (!%col.permanent)
      %col.setClientHidden($Game::clientHiddenTime);

   // The rest of this code handles client side pickup of powerups
   // Only do this if we are the control object.
   if (ServerConnection.getControlObject().getId() != %obj.getId())
   {
      //error("not control object" SPC ServerConnection.getControlObject().getId() SPC %obj.getId());
      return;
   }
      
   if (strstr(%data.shapeFile,"ravel.dts") != -1)
   {
      // Must be the time travel powerup (searched for
      // "ravel" in order to avoid potential caps issues).
      // Add some bonus time -- guess at the value, doesn't have
      // to be right because we'll be updated soon if it's wrong.
      %obj.setMarbleBonusTime(%obj.getMarbleBonusTime() + 5000);
   }

   // pick up the powerup
   if (%data.powerUpId)
      %obj.setPowerUpId(%data.powerUpId);
}