//-----------------------------------------------------------------------------
// Torque Game Engine
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Game start / end events sent from the server
//----------------------------------------------------------------------------
function clientCmdGameStart()
{
   $timeScale = 1.0;
}

function clientCmdGameEnd(%seq)
{   
   $timeScale = 1.0;
}

// Marble Blast specific commands
function clientCmdSetGemCount(%gems,%maxGems)
{
   PlayGui.setGemCount(%gems);
   PlayGui.setMaxGems(%maxGems);
}

function clientCmdSetPoints(%clientid, %points)
{
   PlayGui.setPoints(%clientid, %points);
}

function clientCmdSetGameDuration(%duration, %playStart)
{
   PlayGui.gameDuration = %duration;
   PlayGui.setTimer(0);
         
   if (%playStart > 0)
      $Client::LastGamePlayStart = %playStart;
}

function clientCmdSetEndTime(%playEnd)
{
   $Client::LastGamePlayEnd = %playEnd;
}

function clientCmdSetPowerup(%shapeFile)
{
   PlayGui.setPowerUp(%shapeFile);
}

function clientCmdSetMessage(%message,%time)
{
   PlayGui.setMessage(%message,%time);
   
   if( %message $= "ready" && isObject($Game::StartPad) )
   {
      $Game::StartPad.stopThread( 0 );
      $Game::StartPad.playThread( 0, "start" );
   }
}

function clientCmdSetHelpLine(%helpLine,%beep)
{
   addHelpLine(%helpLine,%beep);
}

function clientCmdSetTimer(%cmd,%time)
{
   switch$ (%cmd)
   {
      case "reset":
         PlayGui.resetTimer();
      case "start":
         PlayGui.startTimer();
      case "stop":
         PlayGui.stopTimer();
      case "set":
         PlayGui.setTimer(%time);
   }
}

function clientCmdCheckpointHit( %sequenceNum )
{
   // If we want to do something with this, here it is
}

// This is a monster
function clientCmdSetGameState(%state, %data)
{
   //echo("@@@@@@@@@@@@ got" SPC %state SPC "state");
   
   // Ok, if the game state is end. Don't let them pause, this will fix the
   // bug where if they pause at the right second it will fuck stuff up -pw
   if( %state $= "end" )
   {
      $GameEndUserName = XBLiveGetUserName();
      $GameEndNoAllowPause = true;
   }
   else
      $GameEndNoAllowPause = false;
        
   if (!isObject(ServerConnection))
   {
      error("clientCmdSetGameState: ServerConnection does not exist");
      return;
   }

   %wasWait = ServerConnection.gameState $= "wait";
   ServerConnection.gameState = %state;
   %isWait = ServerConnection.gameState $= "wait";
   
   if (%wasWait)
   {
      // if we aren't in wait state anymore, we'll need to clear the help message
      // if it isn't already scheduled to be cleared (i.e. it wasn't replaced by another message)
      if (!isEventPending($HelpFadeTimer))
         helpFade(0.50);
   }
   
   // keep rich presence information updated
   if ($Client::connectedMultiplayer)
   {
      // multiplayer
      XBLiveSetRichPresence(XBLiveGetSignInPort(), 2);
   }
   else if (%isWait)
   {
      // menus
      XBLiveSetRichPresence(XBLiveGetSignInPort(), 0);
   }
   else 
   {
      // single player
      XBLiveSetRichPresence(XBLiveGetSignInPort(), 1);
   }

   %allowStats = clientAreStatsAllowed();
   %allowOfflineStats = clientAreOfflineStatsAllowed();
         
   // in single player games, make sure the overall leaderboard is loaded when we enter the ready state
   if (%allowStats && !$Client::connectedMultiplayer && %state $= "ready")
   {
      %mission = GameMissionInfo.getCurrentMission();
      if (!XBLiveAreStatsLoaded($Leaderboard::SPOverall) || 
          !XBLiveAreStatsLoaded(%mission.level))
      {
         echo("Loading single player overall leaderboard & mission leaderboard" SPC %mission.level);
         // read the pair of leaderboards
         XBLiveReadStats($Leaderboard::SPOverall, %mission.level, "", true, true);
      }
   }
   
   // Check here to see if we need to pop the upsell
   if( isDemoLaunch() &&  !$Client::connectedMultiplayer && %state $= "end" )
      UpsellGui.displayUpsell( false, "SPUpsellCallback();", GameEndGui);
      
   // Update the end game gui here
   if( !$Client::connectedMultiplayer && %state $= "end" )
   {
      %mission = GameMissionInfo.getCurrentMission();
      
      %elapsed = PlayGui.elapsedTime;
      %rating = calcRating( %elapsed, %mission.time, %mission.goldTime + $GoldTimeDelta, %mission.difficulty );
      
      %cachedBestTime = $CachedUserTime::levelTime[%mission.level];
       if( XBLiveAreStatsLoaded( %mission.level ) )
         %bestTime = XBLiveGetStatValue( %mission.level, "time" );
       else
         %bestTime = %cachedBestTime;
      
      if( %bestTime > %cachedBestTime || %bestTime == 0 )
          %bestTime = %cachedBestTime;
      
      if( %elapsed < %bestTime || %bestTime == 0 )
		   %isNewBestTime = 1;
         
      if( %isNewBestTime && %allowOfflineStats )
         $CachedUserTime::levelTime[%mission.level] = %elapsed;
		
		// Color coding based on difference from Par Time.
		if (%elapsed < %mission.time) %elapColor = "\c1";
		else if (%elapsed == %mission.time) %elapColor = "\c3";
		else %elapColor = "\c2";
		
		GE_Stats.clear();
 		// Format: "Centered `yay` column for `New Best Time!`" TAB "Time Column" TAB "Tag Column" 
      GE_Stats.addRow(-1, " " TAB %elapColor @ formatTime( %elapsed ) TAB $Text::EndTime );
      GE_Stats.addRow(-1, " " TAB "\c3" @ formatTime( %mission.time ) TAB $Text::ParTime );
      GE_Stats.addRow(-1, " " TAB %rating TAB $Text::EndScore );
      if (%isNewBestTime)
      	GE_Stats.addRow(-1, $Text::NewBestTime SPC " ");
	  	else GE_Stats.addRow(-1, " " TAB formatTime( %bestTime ) TAB $Text::BestTime );
   }
   
   // Do stat write
   if (%allowStats && !$Client::connectedMultiplayer && %state $= "end")
      doSPStatWrite();
     
   if ($Client::connectedMultiplayer)
   {
      // handle multiplayer stats stuff      
      if (%state $= "ready")
      {
         // clear any JoinInProgress users from prior sessions
         if (isObject(StatsJoinInProgressClients))
            StatsJoinInProgressClients.clear();
      }

      // start an MP stats session if we need to.
      // do this even in demo mode (although we won't actually write anything in demo mode)
      // this is so that the join in progress flag for the session works even in a demo.
      // the "play" state is for people who join in progress.
      // JMQ: changed this from "start" to "ready", because client's seem to get multiple 
      // spurious start state messages      
      if (%state $= "ready" || %state $= "play")
      {
         // set flag indicating whether this game should count for rankings.  store this as a global
         // so that we know if our game counted for rankings even if our connection goes away.
         $Client::currentGameCounts = true;
         if (!%allowStats)
            $Client::currentGameCounts = false;
      
         if ($Client::currentGameCounts)
            echo("Game will count for rankings");
         else
            echo("Game will NOT count for rankings");

         if (!XBLiveIsStatsSessionActive())
         {
            
            echo("Starting stats session due to game " @ %state @ " state");
            XBLiveStartStatsSession();

            // we're allowed one read at the beginning of the session.  read the stats 
            // for the level and the MP overall leaderboard for this guy
            if (%allowStats && XBLiveIsStatsSessionActive())
            {
               // at the moment we always reload, we don't care if we already have them loaded
               echo("Loading stats for multiplayer overall board:" SPC $Leaderboard::MPScrumOverall);
               XBLiveReadStats($Leaderboard::MPScrumOverall, $Leaderboard::MPScrumOverall, "onMultiplayerStatsLoaded();", false);
            }       
         
            // we'll need these globals for scoring
            $Game::Mode = "scrum"; // the only mode we support
            $Game::ModeId = ServerConnection.gameModeId;
            $Game::MissionId = ServerConnection.missionId;
         }
         else if (%state $= "ready")
         {
            // its an error if a session is already started when we get "start"
            error("Stats session already active on game start");
         }
      }
            
      // if we are in end state, write scores
      if (XBLiveIsStatsSessionActive() && (%state $= "end" || %state $= "wait"))
      {
         if (%allowStats && $Client::currentGameCounts && %state $= "end")
            clientWriteMultiplayerScores();
         echo("clientCmdSetGameState: Ending stats session and cleaning up stats");
         XBLiveEndStatsSession();
         clientCleanupStats();
      }  
   }
   
   // handle join in progress on server
   if ($Server::Hosting)
   {
      // if we aren't in ranked mode, re-enable join in progress on end or "wait" state
      if (!XBLiveIsRanked() && (%state $= "end" || %state $= "wait"))
         serverSetJIPEnabled(true);
      // if we are in ranked mode, turn of JIP when we enter end state
      if (XBLiveIsRanked() && %state $= "end")
         serverSetJIPEnabled(false);
   }
   
   // update achievement data
   if (clientAreAchievementsAllowed())
   {
//      if (%state $= "ready" && !$UserAchievements::Loaded)
//      {
//         loadAchData();
//      }
      
      if (%state $= "end") // && $UserAchievements::Loaded)
      {
         if (!$Client::connectedMultiplayer)
            doSPAchievementWrite();
         else
         {
            // multiplayer
            
            // the 75 points in MP is set in clientWriteMultiplayerScore
            
            // the achievement code will pull scoring values directly from the leaderboard for
            // the other MP achievements
            checkForAchievements();
         }
         
         // JMQ: this really doesn't work all that well...achievements may not actually be saved yet
         // so getNumAwardedAchievements will return the wrong value.
         // award a gamer picture if they have 3 achievements
//         if (!isPCBuild() && !isDemoLaunch() && XBLiveIsSignedIn())
//         {
//            if (getNumAwardedAchievements() >= 3)
//            {
//               echo("Awarding gamer picture 0");
//               XBAwardGamerPicture( XBLiveGetSignInPort(), 0 );
//            }
//            if (getNumAwardedAchievements() >= 6)
//            {
//               echo("Awarding gamer picture 1");
//               XBAwardGamerPicture( XBLiveGetSignInPort(), 1 );
//            }
//         }
      }
   }
   
   // Do ONE save profile here, instead of a bunch of them, which would
   // cause errors. Use offline stats as the check because we want to make
   // sure that stuff is saved.
   if( %state $= "end" && %allowOfflineStats )
      saveUserProfile();
   
   if (%state $= "start" && isObject(ClientRanks))
      // clear ClientRanks each time a new game starts
      ClientRanks.clear();
      
   if (%state $= "end" && ServerConnection.isMultiplayer)
      // make sure scores in Lobby reflect scoreboard on games that finished normally
      LobbyGui.updateScores();
      
   // demo timer stuff
   if (isDemoLaunch())
   {
      if (%state $= "play" && $Client::connectedMultiplayer)
         startDemoTimer();
      if (%state !$= "play")
         stopDemoTimer();
         
//      if (%state $= "wait" && $Demo::TimeRemaining == 0 && $Client::connectedMultiplayer)
//      {
//         // out of time
//         schedule(0,0,onMPOutOfTime);        
//      }
   }
}