//------------------------------------------------------------------------------
// Torque        Engine
// Copyright (C) GarageGames.com, Inc.
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// ListMenu methods
//------------------------------------------------------------------------------

/// Callback when this gui is added to the sim.
function SinglePlayerListMenu::onAdd(%this)
{
   %this.addRow("Start", "onStartSinglePlayer", 0);
}

//------------------------------------------------------------------------------
// MainMenuButtonHolder methods
//------------------------------------------------------------------------------

function SinglePlayerButtonHolder::onWake(%this)
{
   %this.add(GamepadButtonsGui);

   GamepadButtonsGui.setButton($BUTTON_A, "Go", SinglePlayerListMenu.CallbackOnA);
   GamepadButtonsGui.setButton($BUTTON_B, "Back", SinglePlayerListMenu.CallbackOnB);
}

//------------------------------------------------------------------------------
// global methods
//------------------------------------------------------------------------------

/// Callback from the shell button for starting a single-player level
function onStartSinglePlayer()
{
   Canvas.setContent("LoadingGui");
   LoadingProgress.setValue(0);
   LoadingProgressTxt.setValue("LOADING SINGLE PLAYER TEST");
   Canvas.repaint();
   
   %conn = 0;
   if(isObject(ServerConnection))
   { 
      %conn = ServerConnection;
   }
   else
   {
      %conn = new GameConnection(ServerConnection);
      RootGroup.add(ServerConnection);
   }
      
   //%mission = "levels/sprawl_open.mis";
   %mission = "levels/curvetest.mis";
         
   createServer("SinglePlayer", %mission);
   
   %conn.setConnectArgs($pref::Player::Name);
   %conn.setJoinPassword($Client::Password);
   %conn.connectLocal();
}
