//------------------------------------------------------------------------------
// Torque        Engine
// Copyright (C) GarageGames.com, Inc.
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// ListMenu methods
//------------------------------------------------------------------------------

/// Callback when this gui is added to the sim.
function MultiPlayerListMenu::onAdd(%this)
{
   %this.addRow("Start", "onStartMultiPlayer", 0);
   %this.addRow("Join", "onJoinMultiPlayer", 0);
}

//------------------------------------------------------------------------------
// MainMenuButtonHolder methods
//------------------------------------------------------------------------------

function MultiPlayerButtonHolder::onWake(%this)
{
   %this.add(GamepadButtonsGui);

   GamepadButtonsGui.setButton($BUTTON_A, "Go", MultiPlayerListMenu.CallbackOnA);
   GamepadButtonsGui.setButton($BUTTON_B, "Back", MultiPlayerListMenu.CallbackOnB);
}

//------------------------------------------------------------------------------
// global methods
//------------------------------------------------------------------------------

/// Callback from the shell button for starting a multi-player level
function onStartMultiPlayer()
{
   Canvas.setContent("LoadingGui");
   LoadingProgress.setValue(0);
   LoadingProgressTxt.setValue("LOADING MULTI PLAYER STAGING GROUND");
   Canvas.repaint();
   
   %conn = 0;
   if(isObject(ServerConnection))
   { 
      %conn = ServerConnection;
   }
   else
   {
      %conn = new GameConnection(ServerConnection);
      RootGroup.add(ServerConnection);
   }
   
   // Load the skate-park lobby
   %lobby_mission = "levels/lobby.mis";
         
   createServer("MultiPlayer", %lobby_mission);
   
   %conn.setConnectArgs($pref::Player::Name);
   %conn.setJoinPassword($Client::Password);
   %conn.connectLocal();
}

/// Callback from the shell button for joining an existing multi-player game
function onJoinMultiPlayer()
{
   Canvas.setContent(JoinMultiPlayerGui);
}