//------------------------------------------------------------------------------
// Torque        Engine
// Copyright (C) GarageGames.com, Inc.
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// ListMenu methods
//------------------------------------------------------------------------------

/// Callback when this gui is added to the sim.
function MainListMenu::onAdd(%this)
{
   %this.addRow("Single Player", "onSinglePlayer", 0);
   %this.addRow("Multi-Player", "onMultiPlayer", 0);
   %this.addRow("Options", "onOptions", 6, -15);
   %this.addRow("Exit Game", "onQuit", 8, -15);
}

//------------------------------------------------------------------------------
// MainMenuButtonHolder methods
//------------------------------------------------------------------------------

function MainMenuButtonHolder::onWake(%this)
{
   %this.add(GamepadButtonsGui);

   GamepadButtonsGui.setButton($BUTTON_A, "Go", MainListMenu.CallbackOnA);
}

//------------------------------------------------------------------------------
// global methods
//------------------------------------------------------------------------------

/// Callback from the shell button for triggering single player.
function onSinglePlayer()
{
   Canvas.setContent(SinglePlayerGui);
}

/// Callback from the shell button for triggering single player.
function onMultiPlayer()
{
   Canvas.setContent(MultiPlayerGui);
}

/// Callback from the shell button to bring up the options gui.
function onOptions()
{
   Canvas.setContent(OptionsGui);
}

/// Callback from the shell "quit" button.
function onQuit()
{
   echo("Default implementation. Override onQuit() to add game specific functionality");
   quit();
}
