//------------------------------------------------------------------------------
// Torque        Engine
// Copyright (C) GarageGames.com, Inc.
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// ListMenu methods
//------------------------------------------------------------------------------

/// Callback when this gui is added to the sim.
function LobbyListMenu::onAdd(%this)
{
   %this.addRow("Ready", "onLobbyReady", 0);
}

//------------------------------------------------------------------------------
// LobbyButtonHolder methods
//------------------------------------------------------------------------------

function LobbyButtonHolder::onWake(%this)
{
   %this.add(GamepadButtonsGui);

   GamepadButtonsGui.setButton($BUTTON_A, "Go", LobbyListMenu.CallbackOnA);
   GamepadButtonsGui.setButton($BUTTON_B, "Back", LobbyListMenu.CallbackOnB);
   
   // Enumerate all players connected to server, and display them in a list
   // then start a recurring schedule to update the list
}

//------------------------------------------------------------------------------
// global methods
//------------------------------------------------------------------------------
function onLobbyReady()
{
   // The user is in the lobby and has pressed the "Ready" button. If this is the
   // server, and all users are ready, begin countdown to start the game
}