//------------------------------------------------------------------------------
// Torque        Engine
// Copyright (C) GarageGames.com, Inc.
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// ListMenu methods
//------------------------------------------------------------------------------

/// Callback when this gui is added to the sim.
function JoinMultiPlayerListMenu::onAdd(%this)
{
   %this.addRow("Join Game", "onJoinMultiPlayerGame", 0);
}

function JoinMultiPlayerListMenu::onWake(%this)
{
   // Start query (TEMPORARY, obviously for Xbox we use Xbox Live server querys)
   /*
   queryMasterServer(
      0,          // Query flags
      $Client::GameTypeQuery,       // gameTypes
      $Client::MissionTypeQuery,    // missionType
      0,          // minPlayers
      100,        // maxPlayers
      0,          // maxBots
      2,          // regionMask
      0,          // maxPing
      100,        // minCPU
      0           // filterFlags
   );
   */
   queryLANServers(
      28000,      // lanPort for local queries
      0,          // Query flags
      $Client::GameTypeQuery,       // gameTypes
      $Client::MissionTypeQuery,    // missionType
      0,          // minPlayers
      100,        // maxPlayers
      0,          // maxBots
      2,          // regionMask
      0,          // maxPing
      100,        // minCPU
      0           // filterFlags
   );
   %this.isQueryingServers = true;
}

function JoinMultiPlayerListMenu::onSleep(%this)
{
   cancelServerQuery();
   cancel(%this.serverQuerySchedule);
   %this.isQueryingServers = false;
}

//------------------------------------------------------------------------------
// MainMenuButtonHolder methods
//------------------------------------------------------------------------------

function JoinMultiPlayerButtonHolder::onWake(%this)
{
   %this.add(GamepadButtonsGui);

   GamepadButtonsGui.setButton($BUTTON_A, "Go", JoinMultiPlayerListMenu.CallbackOnA);
   GamepadButtonsGui.setButton($BUTTON_B, "Back", JoinMultiPlayerListMenu.CallbackOnB);
}

//------------------------------------------------------------------------------
// global methods
//------------------------------------------------------------------------------

/// Callback from the shell button for starting a multi-player level
function onJoinMultiPlayerGame()
{
   Canvas.setContent("LoadingGui");
   LoadingProgress.setValue(0);
   LoadingProgressTxt.setValue("JOINING MULTI PLAYER TEST");
   Canvas.repaint();
   
   %conn = 0;
   if(isObject(ServerConnection))
   { 
      %conn = ServerConnection;
      %conn.disconnect();
   }
   else
   {
      %conn = new GameConnection(ServerConnection);
      RootGroup.add(ServerConnection);
   }
   
   %conn.setConnectArgs($pref::Player::Name);
   %conn.setJoinPassword($Client::Password);
   
   %conn.connect($ServerInfo::Address);
}

function onDoneServerQueryStatus()
{
   %sc = getServerCount();
   
   for (%i = 0; %i < %sc; %i++) 
   {
      setServerInfo(%i);
      echo( "[" @ $ServerInfo::Address @ "] " @
         $ServerInfo::Name TAB
         $ServerInfo::Ping TAB
         $ServerInfo::PlayerCount @ "/" @ $ServerInfo::MaxPlayers TAB
         %i);
   }
}

/// This is a global function which the code expects
function onServerQueryStatus(%status, %msg, %value)
{
   // Update query status
   // States: start, update, ping, query, done
   // value = % (0-1) done for ping and query states
   echo("ServerQuery: " SPC %status SPC %msg SPC %value);
   
   switch$ (%status) 
   {
      case "start":
         echo("--Staring Server Query");
         break;

      case "ping":
         echo("--Pinging Servers...");
         break;

      case "query":
         echo("--Querying Servers...");
         break;

      case "done":
         echo("--Done Server Query");
         onDoneServerQueryStatus();
         break;
   }
}