//-----------------------------------------------------------------------------
// Torque Shader Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Mission start / end events sent from the server
//----------------------------------------------------------------------------

function clientCmdMissionStart(%seq)
{
   // The client recieves a mission start right before
   // being dropped into the game.
   
   physicsStartSimulation( "client" );
      
   new SimGroup( ClientMissionCleanup );
}

function clientCmdMissionEnd(%seq)
{
   // Stop all the simulation sounds.
   sfxStopAll( $SimAudioType );
   
   // TODO: this client command is never sent in singleplayer or maybe even
   // not to the local client! Also need to revisit the way decal data
   // is loaded/reloaded between missions.
   
   // Delete all the decals.
   decalManagerClear();

   // Disable mission lighting if it's going, this is here
   // in case the mission ends while we are in the process
   // of loading it.
   $lightingMission = false;
   $sceneLighting::terminateLighting = true;
   
   if( isObject(ClientMissionCleanup) )
   {
      ClientMissionCleanup.delete();
   }
   clearClientPaths();
}

/// Expands the name of a mission into the full 
/// mission path and extension.
function expandMissionFileName( %missionFile )
{         
   // Expand any escapes in it.
   %missionFile = expandFilename( %missionFile );
                 
   // If the mission file doesn't exist... try to fix up the string.      
   if ( !isFile( %missionFile ) ) 
   {
      // Does it need a .mis?
      if ( strStr( %missionFile, ".mis" ) == -1 )
         %newMission = %missionFile @ ".mis";

      if ( !isFile( %newMission ) )
      {
         // Attach a path to it.
         %newMission = expandFilename( "levels/" @ %newMission );
         if ( !isFile( %newMission ) )
         {
            warn( "The mission file '" @ %missionFile @ "' was not found!" );
            return "";
         }
      }

      %missionFile = %newMission;
   }
   
   return %missionFile;
}

/// Load a single player level on the local server.
function loadLevel( %missionNameOrFile )
{
   // Expand the mission name... this allows you to enter
   // just the name and not the full path and extension.
   %missionFile = expandMissionFileName( %missionNameOrFile );
   if ( %missionFile $= "" )
      return false;

   // Prepare and launch the server.
   return createAndConnectToLocalServer( "SinglePlayer", %missionFile );
}
