//-----------------------------------------------------------------------------
// Torque 3D
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------


singleton ShaderData( BL_ShadowFilterShader )
{   
   DXVertexShaderFile 	= "shaders/common/lighting/basic/shadowFilterV.hlsl";
   DXPixelShaderFile 	= "shaders/common/lighting/basic/shadowFilterP.hlsl";
   
   OGLVertexShaderFile 	= "shaders/common/lighting/basic/gl/shadowFilterV.glsl";
   OGLPixelShaderFile 	= "shaders/common/lighting/basic/gl/shadowFilterP.glsl";

   samplerNames[0] = "$diffuseMap";
   
   pixVersion = 2.0;     
};

singleton GFXStateBlockData( BL_ShadowFilterSB : PFX_DefaultStateBlock )
{
   blendDefined = true;
   blendEnable = true;
};

// NOTE: This is ONLY used in Basic Lighting, and 
// only directly by the ProjectedShadow.  It is not 
// meant to be manually enabled like other PostEffects.
singleton PostEffect( BL_ShadowFilterPostFx )
{
   shader = BL_ShadowFilterShader;
   stateBlock = PFX_DefaultStateBlock;
   targetClear = "PFXTargetClear_OnDraw";
   targetClearColor = "0 0 0 0";
   texture[0] = "$inTex";
   target = "$outTex";   
};
