//------------------------------------------------------------------------------
// Shape Baker
// Copyright (C) GameClay LLC
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// BakePackage
// This is for command-line executed shape baking
//------------------------------------------------------------------------------
package BakePackage
{

//------------------------------------------------------------------------------
// Lifecycle
//------------------------------------------------------------------------------
function onStart()
{
   Parent::onStart();
   
   // Common shape bake stuff
   exec("./common/main.cs");
   
   // Specific tasks
   exec("./shadowMapIndices.cs");
   
   echo(" % - Initialized Shape Baking Package");
   
   // Return control back to this package after the rest of the engine is 
   // finished with its initialization.
   schedule(0, 0, "processBakeTasks");
}

function onExit()
{
   Parent::onExit();
}

function processBakeTasks()
{
   echo("Processing bake tasks...");
   
   // Process tasks
   // TODO: Task queue and file-loading of task queue
   
   bakeShadowMapIndices(); // hack...
   
   quit();
}

//------------------------------------------------------------------------------
// displayHelp
// Prints the command line options available for this mod.
//------------------------------------------------------------------------------
function displayHelp() 
{
   Parent::displayHelp();

   error("Shape Bake Mod options:\n" @
         "  -optimizeShape <shapeFile>    Optimize the specified DAE\n");
}

//------------------------------------------------------------------------------
// parseArgs
// Parses the command line arguments and processes those valid for this mod.
//------------------------------------------------------------------------------
function parseArgs()
{
   // Let the parent grab the arguments it wants first.
   Parent::parseArgs();

   // Loop through the arguments.
   for (%i = 1; %i < $Game::argc; %i++)
   {
      %arg = $Game::argv[%i];
      %nextArg = $Game::argv[%i+1];
      %hasNextArg = $Game::argc - %i > 1;
   
      switch$ (%arg)
      {
         case "-optimizeShape":
            $argUsed[%i]++;
            
            if(%hasNextArg)
            {
               $optimizeShapeCmdLine = %nextArg;
               $argUsed[%i + 1]++;
               %i++;
            }
            else
               error("Error: Missing Command Line argument. Usage: -optimizeShape <path_to_DAE>");
      }
   }
}

}; // package BakePackage

activatePackage(BakePackage);