singleton Material(DefaultMaterial) {

   translucent[0] = false;
   friction = 1;

   restitution = 1;
   force = 0;

   pixelSpecular[0] = true;
   specular[0] = "0.8 0.8 0.6 1.0";
   specularPower[0] = 12.0;
};

singleton Material(CementMaterial) {
   translucent[0] = false;
   friction = 1;
   restitution = 1;
   force = 0;

   pixelSpecular[0] = true;
   specular[0] = "0.8 0.8 0.6 1.0";
   specularPower[0] = 12.0;
};

//-----------------------------------------------------------------------------
// Set Dressing Textures
//-----------------------------------------------------------------------------
new ShaderData( NoiseTile )
{
   DXVertexShaderFile   = "shaders/noiseTileV.hlsl";
   DXPixelShaderFile    = "shaders/noiseTileP.hlsl";
   pixVersion = 2.0;
};

new ShaderData( HalfTile )
{
   DXVertexShaderFile   = "shaders/halfTileV.hlsl";
   DXPixelShaderFile    = "shaders/halfTileP.hlsl";
   pixVersion = 2.0;
};


// Metal Plate random tile texture
singleton Material( Material_Plate )
{
   mapTo = "plate_1";
   baseTex[0] = "./textures/plate.randomize";
   bumpTex[0] = "./textures/plate.normal";

   friction = 1;
   restitution = 1;
   force = 0;   

   specular[0] = "1.0 1.0 0.8 1.0";
   specularPower[0] = 8.0;
};

singleton Material( Material_Tile_Beginner )
{
   mapTo = tile_beginner;
   baseTex[0] = "./textures/tile_beginner";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};

singleton Material( Material_Tile_Beginner_Red  )
{
   mapTo = tile_beginner_red;
   baseTex[0] = "./textures/tile_beginner";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise_red";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};


singleton Material( Material_Tile_Beginner_Blue  )
{
   mapTo = tile_beginner_blue;
   baseTex[0] = "./textures/tile_beginner";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise_blue";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};


singleton Material( Material_Tile_Intermediate  )
{
   mapTo = tile_intermediate;
   baseTex[0] = "./textures/tile_intermediate";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};

singleton Material( Material_Tile_Intermediate_green  )
{
   mapTo = tile_intermediate_green;
   baseTex[0] = "./textures/tile_intermediate";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise_green";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};

singleton Material( Material_Tile_Intermediate_red  )
{
   mapTo = tile_intermediate_red;
   baseTex[0] = "./textures/tile_intermediate";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise_red";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};

singleton Material( Material_Tile_Advanced  )
{
   mapTo = tile_advanced;
   baseTex[0] = "./textures/tile_advanced";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};

singleton Material( Material_Tile_Advanced_Blue  )
{
   mapTo = tile_advanced_blue;
   baseTex[0] = "./textures/tile_advanced";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise_blue";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;
   friction = 1;
   restitution = 1;
   force = 0;

   shader = NoiseTile;
   version = 2.0;
};

singleton Material( Material_Tile_Advanced_Green  )
{
   mapTo = tile_advanced_green;
   baseTex[0] = "./textures/tile_advanced";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise_green";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;

   friction = 1;
   restitution = 1;
   force = 0;
};

singleton Material( Material_Tile_Beginner_shadow : Material_Tile_Beginner )
{
   mapTo = tile_beginner_shadow;
};

singleton Material( Material_Tile_Beginner_Red_shadow : Material_Tile_Beginner_Red )
{
   mapTo = tile_beginner_red_shadow;
};


singleton Material( Material_Tile_Beginner_Blue_shadow : Material_Tile_Beginner_Blue  )
{
   mapTo = tile_beginner_blue_shadow;
};


singleton Material( Material_Tile_Intermediate_shadow : Material_Tile_Intermediate )
{
   mapTo = tile_intermediate_shadow;
};

singleton Material( Material_Tile_Intermediate_green_shadow : Material_Tile_Intermediate_green )
{
   mapTo = tile_intermediate_green_shadow;
};

singleton Material( Material_Tile_Intermediate_red_shadow : Material_Tile_Intermediate_red )
{
   mapTo = tile_intermediate_red_shadow;
};

singleton Material( Material_Tile_Advanced_shadow : Material_Tile_Advanced )
{
   mapTo = tile_advanced_shadow;
};

singleton Material( Material_Tile_Advanced_Blue_shadow : Material_Tile_Advanced_Blue )
{
   mapTo = tile_advanced_blue_shadow;
};

singleton Material( Material_Tile_Advanced_Green_shadow : Material_Tile_Advanced_Green )
{
   mapTo = tile_advanced_green_shadow;
};

singleton Material( Material_Tile_Underside )
{
   mapTo = tile_underside;
   baseTex[0] = "./textures/tile_underside";
   bumpTex[0] = "./textures/tile_intermediate.normal";
   texture[2] = "./textures/noise";
   
   specular[0] = "1 1 1 1";
   specularPower[0] = 40.0;
};


singleton Material(Material_Wall_Beginner : DefaultMaterial)
{
   mapTo="wall_beginner";

   baseTex[0] = "./textures/wall_beginner";
   //bumpTex[0] = "./textures/plate.normal";
};

singleton Material(Material_Edge_White : DefaultMaterial)
{
   mapTo = "edge_white";
   baseTex[0] = "./textures/edge_white";
   bumpTex[0] = "./textures/edge.normal";

   specular[0] = "0.8 0.8 0.8 1.0";
   specularPower[0] = 50.0;
};

singleton Material(Material_Edge_White_shadow : DefaultMaterial)
{
   mapTo = "edge_white_shadow";
   baseTex[0] = "./textures/edge_white_shadow";
   bumpTex[0] = "./textures/edge.normal";

   specular[0] = "0.2 0.2 0.2 0.2";
   specularPower[0] = 50.0;
   
};

singleton Material(Material_beam : DefaultMaterial) {
   baseTex[0] = "./textures/beam";
   bumpTex[0] = "./textures/beam.normal";
};

singleton Material(Material_BeamSide : DefaultMaterial) {
   baseTex[0] = "./textures/beam_side";
   bumpTex[0] = "./textures/beam_side.normal";
};

singleton Material(Tube_beginner : DefaultMaterial)
{
   mapto = "tube_neutral";
   baseTex[0] = "./textures/tube_beginner";
};

singleton Material(Tube_intermediate : DefaultMaterial)
{
   mapto="tube_cool";
   baseTex[0] = "./textures/tube_intermediate";
};

singleton Material(Tube_Advanced : DefaultMaterial)
{
   mapto="tube_warm";
   baseTex[0] = "./textures/tube_advanced";
};

// ---------------------------------------------------------------------------
// Friction Materials
// ---------------------------------------------------------------------------

singleton Material(Material_LowFriction) {
   baseTex[0] = "./textures/friction_low";
   bumpTex[0] = "./textures/friction_low.normal";
   friction = 0.20;
   restitution = 1.0;
   force = 0;
   
   mapTo = friction_low;
   
   cubemap[0] = iceCubemap;
   
   //FUCK ICE
   //baseTex[1] = "./textures/friction_low";
   //bumpTex[1] = "./textures/friction_low.normal";
   //translucent[1] = true;
   pixelSpecular[0] = true;
   specular[0] = "1.0 1.0 1.0 0.8";
   specularPower[0] = 128.0;
};

//updated
singleton Material(Material_HighFriction : DefaultMaterial) {
   friction = 4.5;
   restitution = 0.5;
   force = 0;
  
   specular[0] = "0.3 0.3 0.35 1.0";
   specularPower[0] = 10.0;
   
   MAPTO = "friction_high";
   baseTex[0] = "./textures/friction_high";
   bumpTex[0] = "./textures/friction_high.normal";
};

singleton Material(Material_HighFriction_Shadow : DefaultMaterial) {
   friction = 4.5;
   restitution = 0.5;
   force = 0;
  
   specular[0] = "0.15 0.15 0.16 1.0";
   specularPower[0] = 10.0;
   
   MAPTO = "friction_high_shadow";
   baseTex[0] = "./textures/friction_high_shadow";
   bumpTex[0] = "./textures/friction_high.normal";
};

singleton Material(Material_LowFriction_Shadow) {
   baseTex[0] = "./textures/friction_low_shadow";
   bumpTex[0] = "./textures/friction_low.normal";
   friction = 0.20;
   restitution = 1.0;
   force = 0;
   
   mapTo = friction_low_shadow;
   
   cubemap[0] = iceCubemap;
   
   pixelSpecular[0] = true;
   specular[0] = "0.3 0.3 0.35 1.0";
   specularPower[0] = 128.0;
};

// Adding this back in
singleton Material(Material_stripe_caution : DefaultMaterial)
{
   mapTo = stripe_caution;
   baseTex[0] = "./textures/stripe_caution";
};

// Default marble skin showing reflections
singleton Material(marble01_skin)
{
   mapTo = "marble01.skin";
   
   diffuseMap[0] = "./textures/noise.jpg";
   
   dynamicCubemap = true;
};

//New textures
singleton CubemapData( ChromeACubemap )
{
   cubeFace[0] = "./textures/cubemapA0001";
   cubeFace[1] = "./textures/cubemapA0003";
   cubeFace[2] = "./textures/cubemapA0002";
   cubeFace[3] = "./textures/cubemapA0000";
   cubeFace[4] = "./textures/cubemapA0004";
   cubeFace[5] = "./textures/cubemapA0005";
};

singleton CubemapData( MarsChromeCubemap )
{
   cubeFace[0] = "./textures/marschrome0001";
   cubeFace[1] = "./textures/marschrome0003";
   cubeFace[2] = "./textures/marschrome0002";
   cubeFace[3] = "./textures/marschrome0000";
   cubeFace[4] = "./textures/marschrome0004";
   cubeFace[5] = "./textures/marschrome0005";
};

singleton Material(testtube_NEW_test_tile_material)
{
	mapTo = "tile_material";

	diffuseMap[0] = "art/marbleblastultra/textures/rollingsurface_color";
	normalMap[0] = "art/marbleblastultra/textures/rollingsurface_normal";
	specularMap[0] = "";

	diffuseColor[0] = "1 1 1 1";
	specular[0] = "0.996078 0.764706 0.00784314 1";
	specularPower[0] = 2;

	doubleSided = false;
	translucent = false;
	translucentBlendOp = "None";
   cubemap = "MarsChromeCubemap";
   pixelSpecular[0] = "1";
   scrollDir[0] = "0 0.345";
   scrollSpeed[0] = "4.471";
   
   vertColor[0] = true;
};

singleton Material(testtube_NEW_side_material)
{
	mapTo = "side_material";

	diffuseMap[0] = "art/marbleblastultra/textures/blackeedge";
	normalMap[0] = "";
	specularMap[0] = "";

	diffuseColor[0] = "0.00392157 0.00392157 0.00392157 1";
	specular[0] = "0.176471 0.00392157 0.270588 1";
	specularPower[0] = 2;

	doubleSided = false;
	translucent = false;
	translucentBlendOp = "None";
   pixelSpecular[0] = "1";
};

singleton Material(structure_green_structure_metal)
{
	mapTo = "green_structure_metal";

	diffuseMap[0] = "art/marbleblastultra/textures/support_color";
	normalMap[0] = "art/marbleblastultra/textures/support_normal";
	specularMap[0] = "art/marbleblastultra/textures/support_spec";

	vertColor[0] = true;
	diffuseColor[0] = "0.435294 0.717647 0.454902 1";
	specular[0] = "0 0 0 1";
	specularPower[0] = 2;

	doubleSided = false;
	translucent = false;
	translucentBlendOp = "None";
};

singleton Material(structure_cable)
{
	mapTo = "cable";

	diffuseMap[0] = "art/marbleblastultra/textures/support_color";
	normalMap[0] = "";
	specularMap[0] = "";

	diffuseColor[0] = "0 0 0 1";
	specular[0] = "0 0 0 1";
	specularPower[0] = 2;

	vertColor[0] = true;
		
	doubleSided = false;
	translucent = false;
	translucentBlendOp = "None";
};

singleton Material(structure_cable_lite)
{
	mapTo = "cable_lite";

	diffuseMap[0] = "art/marbleblastultra/textures/support_color";
	normalMap[0] = "";
	specularMap[0] = "";

	diffuseColor[0] = "1 0.964706 0 1";
	specular[0] = "0 0 0 1";
	specularPower[0] = 2;
	
	vertColor[0] = true;

	doubleSided = false;
	translucent = false;
	translucentBlendOp = "None";
};

singleton Material(gembeam_material)
{
   mapTo = "mistyglow";
   
   diffuseColor[0] = "0.992157 0.992157 0.996078 1";
   translucent = true;
   glow[0] = true;
   diffuseMap[0] = "art/marbleblastultra/gembeam";
   emissive[0] = "1";
   animFlags[0] = "0x00000001";
   scrollDir[0] = "0.276 0.207";
   scrollSpeed[0] = "0.235";
   translucentBlendOp = "AddAlpha";
};

