//-----------------------------------------------------------------------------
// Marble Blast Fusion
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Superjump powerUp
//-----------------------------------------------------------------------------

/*datablock SFXProfile(doSuperJumpSfx)
{
   filename    = "~/data/sound/use_superjump";
   description = AudioClose3d;
   preload = true;
};

datablock SFXProfile(PuSuperJumpVoiceSfx)
{
   filename    = "~/data/sound/super_jump";
   description = Audio2D;
   preload = true;
};*/

datablock ItemData(SuperJumpItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";
   powerUpId = 1;

   activeAudio = DoSuperJumpSfx;
   pickupAudio = PuSuperJumpVoiceSfx;

   // Basic Item properties
   shapeFile = "~/shapes/items/superjump.dts";
   bmpFile = "powerup_jump.png";
   mass = 1;
   friction = 1;
   elasticity = 0.3;
   emap = false;

   // Dynamic properties defined by the scripts
   pickupText = $Text::ASuperJump;
   useName = $Text::UseSuperJump;
   maxInventory = 1;
};

//-----------------------------------------------------------------------------
// Superspeed powerUp
//-----------------------------------------------------------------------------

/*datablock SFXProfile(doSuperSpeedSfx)
{
   filename    = "~/data/sound/use_speed";
   description = AudioClose3d;
   preload = true;
};

datablock SFXProfile(PuSuperSpeedVoiceSfx)
{
   filename    = "~/data/sound/super_speed";
   description = Audio2D;
   preload = true;
};*/

datablock ItemData(SuperSpeedItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";
   powerUpId = 2;

   activeAudio = DoSuperSpeedSfx;
   pickupAudio = PuSuperSpeedVoiceSfx;

   // Basic Item properties
   shapeFile = "~/shapes/items/superspeed.dts";
   bmpFile = "powerup_speed.png";
   mass = 1;
   friction = 1;
   elasticity = 0.3;
   emap = false;

   // Dynamic properties defined by the scripts
   pickupText = $Text::ASuperSpeed;
   useName = $Text::UseSuperSpeed;
   maxInventory = 1;
};

//-----------------------------------------------------------------------------
// Helicopter powerUp
//-----------------------------------------------------------------------------

/*datablock SFXProfile(PuGyrocopterVoiceSfx)
{
   filename    = "~/data/sound/gyrocopter";
   description = Audio2D;
   preload = true;
};*/

datablock ItemData(HelicopterItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";
   powerUpId = 5;

   pickupAudio = PuGyrocopterVoiceSfx;

   // Basic Item properties
   shapeFile = "~/shapes/images/helicopter.dts";
   bmpFile = "powerup_copter.png";
   mass = 1;
   friction = 1;
   elasticity = 0.3;

   // Dynamic properties defined by the scripts
   pickupText = $Text::AGyrocopter;
   useName = $Text::UseGyrocopter;
   maxInventory = 1;
};

/*datablock SFXProfile(HelicopterLoopSfx)
{
   filename    = "~/data/sound/Use_Gyrocopter";
   description = AudioClosestLooping3d;
   preload = true;
};*/

datablock ShapeBaseImageData(HelicopterImage)
{
   // Basic Item properties
   shapeFile = "~/shapes/images/helicopter_image.dts";
   emap = true;
   mountPoint = 0;
   offset = "0 0 0";
   stateName[0]                     = "Rotate";
   stateSequence[0]                 = "rotate";
   stateSound[0] = HelicopterLoopSfx;
   ignoreMountRotation = true;
};

//-----------------------------------------------------------------------------
// Blast marble powerUp
//-----------------------------------------------------------------------------

/*datablock SFXProfile(doBlastSfx)
{
   filename    = "~/data/sound/use_blast";
   description = AudioClose3d;
   preload = true;
};

datablock SFXProfile(PuBlastVoiceSfx)
{
   filename    = "~/data/sound/ultrablast";
   description = Audio2D;
   preload = true;
};*/

datablock ShapeBaseImageData(BlastImage)
{
   // Basic Item properties
   shapeFile = "~/shapes/images/distort.dts";
   emap = false;
   mountPoint = 0;
   offset = "0 0 0";
   stateName[0]                     = "Grow";
   stateSequence[0]                 = "grow";
//   stateSound[0] = doBlastSfx;
   ignoreMountRotation = true;
};


datablock ItemData(BlastItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";
   powerUpId = 6;

   activeAudio = DoBlastSfx;
   pickupAudio = PuBlastVoiceSfx;

   // Basic Item properties
   shapeFile = "~/shapes/images/blast.dts";
   bmpFile = "powerup_blast.png";
   mass = 1;
   friction = 1;
   elasticity = 0.3;
   
   // Dynamic properties defined by the scripts
   pickupText = $Text::ABlast;
   useName = $Text::UseBlast;
   maxInventory = 1;
}; 

//-----------------------------------------------------------------------------
// Mega marble powerUp
//-----------------------------------------------------------------------------

/*datablock SFXProfile(DoMegaMarbleSfx)
{
   filename    = "~/data/sound/use_mega";
   description = AudioClose3d;
   preload = true;
};

datablock SFXProfile(PuMegaMarbleVoiceSfx)
{
   filename    = "~/data/sound/mega_marble";
   description = Audio2D;
   preload = true;
};

datablock SFXProfile(ShrinkMegaMarbleSfx)
{
   filename    = "~/data/sound/MegaShrink";
   description = AudioClose3d;
   preload = true;
};*/

datablock ItemData(MegaMarbleItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";
   powerUpId = 7;

   activeAudio = DoMegaMarbleSfx;
   pickupAudio = PuMegaMarbleVoiceSfx;

   // Basic Item properties
   shapeFile = "~/shapes/images/grow.dts";
   bmpFile = "powerup_mega.png";
   mass = 1;
   friction = 1;
   elasticity = 0.3;

   // Dynamic properties defined by the scripts
   pickupText = $Text::AMegaMarble;
   useName = $Text::UseMegaMarble;
   maxInventory = 1;
};


//-----------------------------------------------------------------------------
// Special non-inventory power ups
//-----------------------------------------------------------------------------

/*datablock SFXProfile(PuTimeTravelVoiceSfx)
{
   filename    = "~/data/sound/time_travel";
   description = Audio2D;
   preload = true;
};*/

datablock ItemData(TimeTravelItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";

   // Basic Item properties
   pickupAudio = PuTimeTravelVoiceSfx;
   shapeFile = "~/shapes/items/timetravel.dts";
   mass = 6;
   friction = 1;
   elasticity = 0.3;
   emap = false;

   // Dynamic properties defined by the scripts
   noRespawn = true;
   pickupText = $Text::ATimeTravelBonus;
   maxInventory = 1;
};

/*datablock SFXProfile(PuAntiGravityVoiceSfx)
{
   filename    = "~/data/sound/pu_gravity";
   description = Audio2D;
   preload = true;
};*/

datablock ItemData(AntiGravityItem)
{
   // Mission editor category
   category = "Powerups";
   className = "PowerUp";

   pickupAudio = PuAntiGravityVoiceSfx;
   pickupText = $Text::AGravityMod;

   // Basic Item properties
   shapeFile = "~/shapes/items/antiGravity.dts";
   mass = 1;
   friction = 1;
   elasticity = 0.3;
   emap = false;

   // Dynamic properties defined by the scripts
   maxInventory = 1;
};


//-----------------------------------------------------------------------------
// power-up parameters
//-----------------------------------------------------------------------------

datablock PowerUpData(PowerUpDefs)
{
   // This datablock holds the properties
   // of all the powerups.
   
   // Possible properties of powerups.
   // Note: leave value alone to accept default behavior.
   //    boostDir -- direction that boost applies
   //    boostAmount -- impulse of boost
   //    boostMassless -- whether boost is massless or not
   //    airAccel -- modify air acceleration by this factor
   //    gravityMod -- modify gravity by this factor
   //    bounce -- change bounce restitution to this value
   //    repulseMax -- apply up to this much force to other marbles
   //    repulseDist -- max distance at which repulse force is applied
   //    massScale -- scale mass by this amount
   //    sizeScale -- scale size by this amount
   //    activateTime -- time, in ms, for powerup to be activated and have an effect

   // Blast Ability -- triggered by energy level not powerup
   image[0] = BlastImage;
   emitter[0] = BlastEmitter;
   boostDir[0] = "0 0 1";
   boostAmount[0] = 8; // small hop to get off surface
   duration[0] = 384;
   repulseMax[0] = 60;
   repulseDist[0] = 10;
   activateTime[0] = 150;

   // Super Jump
   emitter[1] = MarbleSuperJumpEmitter; 		
   duration[1] = 1000;
   boostDir[1] = "0 0 1";
   boostAmount[1] = 20;
   boostMassless[1] = 0.7;
   activateTime[1] = 0;
   
   // Super Speed
   emitter[2] = MarbleSuperSpeedEmitter;
   duration[2] = 1000;
   boostDir[2] = "0 1 0";
   boostAmount[2] = 25;
   boostMassless[2] = 0.7;
   activateTime[2] = 100;

   // Super Bounce
   //image[3] = SuperBounceImage;
   //duration[3] = 5000;
   //bounce[3] = 0.9;
   //activateTime[3] = 0;

   // Shock Absorber
   //image[4] = ShockAbsorberImage;
   //duration[4] = 5000;
   //boost[4] = 0.01;
   //activateTime[4] = 0;

   // Helicopter
   image[5] = HelicopterImage;
   duration[5] = 5000;
   gravityMod[5] = 0.25;
   airAccel[5] = 2;
   activateTime[5] = 70;

   // Blast
//   image[6] = BlastImage;
   duration[6] = 400;
   blastRecharge[6] = true;
   
   // Mega marble
   image[7] = MegaMarbleImage;
   duration[7] = 10000;
   boostAmount[7] = 5; // small hop to get off surface
   massScale[7] = 5;
   sizeScale[7] = 2.25;
   boostDir[7] = "0 0 1";
   activateTime[7] = 100;
   
   // Time freeze marble
   image[8] = TimeFreezeImage;
   duration[8] = 5000;
   timeFreeze[8] = 5000;
   activateTime[8] = 0;

   // currently unused...
   //emitter[3] = MarbleSuperBounceEmitter;
   //emitter[4] = MarbleShockAbsorberEmitter;
   //emitter[5] = MarbleHelicopterEmitter;
};