//-----------------------------------------------------------------------------
/*
datablock ParticleData(BounceParticle)
{
   textureName          = "~/data/particles/burst";
   dragCoeffiecient     = 0.5;
   gravityCoefficient   = -0.1;
   windCoefficient      = 0;
   inheritedVelFactor   = 0;
   constantAcceleration = -2;
   lifetimeMS           = 400;
   lifetimeVarianceMS   = 50;
   useInvAlpha =  false;
   spinSpeed     = 90;
   spinRandomMin = -90.0;
   spinRandomMax =  90.0;

   colors[0]     = "0.5 0.5 0.5 0.3";
   colors[1]     = "0.3 0.3 0.2 0.1";
   colors[2]     = "0.2 0.2 0.1 0.0";

   sizes[0]      = 0.8;
   sizes[1]      = 0.4;
   sizes[2]      = 0.2;

   times[0]      = 0;
   times[1]      = 0.75;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MarbleBounceEmitter)
{
   ejectionPeriodMS = 10;
   periodVarianceMS = 0;
   ejectionVelocity = 6.0;
   velocityVariance = 0.25;
   thetaMin         = 80.0;
   thetaMax         = 90.0;
   lifetimeMS       = 250;
   particles = "BounceParticle";
};

//-----------------------------------------------------------------------------

datablock ParticleData(TrailParticle)
{
   textureName          = "~/data/particles/burst";
   dragCoeffiecient     = 1.0;
   gravityCoefficient   = 0;
   windCoefficient      = 0;
   inheritedVelFactor   = 1;
   constantAcceleration = 0;
   lifetimeMS           = 100;
   lifetimeVarianceMS   = 10;
   useInvAlpha =  true;
   spinSpeed     = 0;

   colors[0]     = "1 1 0 0.0";
   colors[1]     = "1 1 0 1";
   colors[2]     = "1 1 1 0.0";

   sizes[0]      = 0.7;
   sizes[1]      = 0.4;
   sizes[2]      = 0.1;

   times[0]      = 0;
   times[1]      = 0.15;
   times[2]      = 1.0;
};

//datablock ParticleData(TrailParticle2)
//{
//   textureName          = "~/data/particles/star";
//   dragCoeffiecient     = 1.0;
//   gravityCoefficient   = 0;
//   windCoefficient      = 0;
//   inheritedVelFactor   = 0;
//   constantAcceleration = -2;
//   lifetimeMS           = 400;
//   lifetimeVarianceMS   = 100;
//   useInvAlpha =  true;
//   spinSpeed     = 90;
//   spinRandomMin = -90.0;
//   spinRandomMax =  90.0;
//
//   colors[0]     = "0.9 0.0 0.0 0.9";
//   colors[1]     = "0.9 0.9 0.0 0.9";
//   colors[2]     = "0.9 0.9 0.9 0.0";
//
//   sizes[0]      = 0.165;
//   sizes[1]      = 0.165;
//   sizes[2]      = 0.165;
//
//   times[0]      = 0;
//   times[1]      = 0.55;
//   times[2]      = 1.0;
//};

datablock ParticleData(TrailParticle2)
{
   textureName          = "~/data/particles/burst";
   dragCoefficient     = 0.0;
   gravityCoefficient   = 0;   
   inheritedVelFactor   = 0.00;
   lifetimeMS           = 2000;
   lifetimeVarianceMS   = 0;
   useInvAlpha = false;
   spinRandomMin = -90.0;
   spinRandomMax = 90.0;

   colors[0]     = "0.5 0.3 0.2 1.0";
   colors[1]     = "0.5 0.3 0.2 1.0";
   colors[2]     = "0.2 0.0 0.0 0.0";

   sizes[0]      = 0.6;
   sizes[1]      = 0.5;
   sizes[2]      = 0.1;

   times[0]      = 0.0;
   times[1]      = 0.5;
   times[2]      = 1.0;
};

datablock ParticleEmitterData(MarbleTrailEmitter)
{
   ejectionPeriodMS = 9;
   periodVarianceMS = 0;
   ejectionVelocity = 3.0;
   velocityVariance = 0.25;
   thetaMin         = 60.0;
   thetaMax         = 90.0;
   lifetimeMS       = 1000000;
   particles = TrailParticle2;
};
*/
//-----------------------------------------------------------------------------
// ActivePowerUp
// 0 - no active powerup
// 1 - Super Jump
// 2 - Super Speed
// 3 - Super Bounce
// 4 - Indestructible

datablock SFXProfile(Bounce1Sfx)
{
   filename    = "sound/bouncehard1";
   description = AudioClosest3D;
   preload = true;
};

datablock SFXProfile(Bounce2Sfx)
{
   filename    = "sound/bouncehard2";
   description = AudioClosest3D;
   preload = true;
};

datablock SFXProfile(Bounce3Sfx)
{
   filename    = "sound/bouncehard3";
   description = AudioClosest3D;
   preload = true;
};

datablock SFXProfile(Bounce4Sfx)
{
   filename    = "sound/bouncehard4";
   description = AudioClosest3D;
   preload = true;
};

datablock SFXProfile(MegaBounce1Sfx)
{
   filename    = "sound/mega_bouncehard1";
   description = AudioClose3D;
   preload = true;
};

datablock SFXProfile(MegaBounce2Sfx)
{
   filename    = "sound/mega_bouncehard2";
   description = AudioClose3D;
   preload = true;
};

datablock SFXProfile(MegaBounce3Sfx)
{
   filename    = "sound/mega_bouncehard3";
   description = AudioClose3D;
   preload = true;
};

datablock SFXProfile(MegaBounce4Sfx)
{
   filename    = "sound/mega_bouncehard4";
   description = AudioClose3D;
   preload = true;
};

datablock SFXProfile(JumpSfx)
{
   filename    = "sound/Jump";
   description = AudioClosest3D;
   preload = true;
};

datablock SFXProfile(RollingHardSfx)
{
   filename    = "sound/Rolling_Hard";
   description = AudioClosestLoop3D;
   volume = 0.91;
   preload = true;
};

datablock SFXProfile(RollingMegaSfx)
{
   filename    = "sound/mega_roll";
   description = AudioCloseLoop3D;
   volume = 0.91 * 0.85;
   preload = true;
};

datablock SFXProfile(RollingIceSfx)
{
   filename    = "sound/ice_roll";
   description = AudioClosestLoop3D;
   volume = 0.91 * 0.85;
   preload = true;
};

datablock SFXProfile(SlippingSfx)
{
   filename    = "sound/Sliding";
   description = AudioClosestLoop3D;
   volume = 0.60;
   preload = true;
};

datablock ReflectorDesc(DefaultMarbleReflector)
{
   texSize = 64;
   
   nearDist = 0.1;
   farDist = 300;
   
   useOcclusionQuery = false;
};

datablock MarbleData(DefaultMarble)
{   
   shapeFile = "art/shapes/balls/marble01.dts";
   emap = true;
   renderFirstPerson = true;
   maxRollVelocity = 15;
   angularAcceleration = 75;
   brakingAcceleration = 30;
   gravity = 20;
   size = 1.5;
   megaSize = 1.5 * 2.25;
   mass = 1;
   staticFriction = 1.1;
   kineticFriction = 0.7;
   bounceKineticFriction = 0.2;
   maxDotSlide = 0.5;
   bounceRestitution = 0.5;
   jumpImpulse = 7.5;
   maxForceRadius = 50;
   
   blastRechargeTime = 36000;
   maxNaturalBlastRecharge = 30000;

   bounce1 = Bounce1Sfx;
   bounce2 = Bounce2Sfx;
   bounce3 = Bounce3Sfx;
   bounce4 = Bounce4Sfx;
   megabounce1 = MegaBounce1Sfx;
   megabounce2 = MegaBounce2Sfx;
   megabounce3 = MegaBounce3Sfx;
   megabounce4 = MegaBounce4Sfx;

   rollHardSound = RollingHardSfx;
   rollMegaSound = RollingMegaSfx;
   rollIceSound = RollingIceSfx;
   slipSound = SlippingSfx;
   jumpSound = JumpSfx;
   
   // Emitters
   minTrailSpeed = 15;            // Trail threshold
   trailEmitter = MarbleTrailEmitter;
   
   minBounceSpeed = 3;           // Bounce threshold
   bounceEmitter = MarbleBounceEmitter;

   powerUps = PowerUpDefs;

   // Allowable Inventory Items
   maxInv[SuperJumpItem] = 20;
   maxInv[SuperSpeedItem] = 20;
   maxInv[SuperBounceItem] = 20;
   maxInv[IndestructibleItem] = 20;
   maxInv[TimeTravelItem] = 20;
//   maxInv[GoodiesItem] = 10;

   // Dynamic Cube Map
   cubeReflectorDesc = DefaultMarbleReflector;
};