//-----------------------------------------------------------------------------
// Torque Game Engine
//
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------

datablock SFXProfile(GotGemSfx)
{
   filename    = "sound/gem_collect";
   description = Audio2D;
   volume = 0.6;
   preload = true;
};

datablock SFXProfile(OpponentGotGemSfx)
{
   filename    = "sound/opponent_gem_collect";
   description = AudioClose3d;
   volume = 0.6;
   preload = true;
};

datablock SFXProfile(GotAllGemsSfx)
{
   filename    = "sound/gem_all";
   description = Audio2D;
   volume = 0.6;
   preload = true;
};

datablock ItemData(GemItem)
{
   // Mission editor category
   category = "SingleplayerGems";
   class = "Gem";

   // Basic Item properties
   shapeFile = "art/shapes/items/gem.dts";
   mass = 1;
   friction = 1;
   elasticity = 0;
   gravityMod = 0;

   // Dynamic properties defined by the scripts
   pickupName = "a gem!";
   maxInventory = 1;
   noRespawn = true;
   gemType = 1;
   noPickupMessage = true;

   scaleFactor = 1.5;

   renderGemAura = true;
   gemAuraTextureName = "~/data/textures/gemAura";
   noRenderTranslucents = true;
   referenceColor = "0.9 0 0";
   points = 1;
   
   addToHUDRadar = true;

   buddyShapeName = "art/shapes/items/gembeam.dts";
   buddySequence = "ambient";
};

datablock ItemData(GemItem_2pts: GemItem) 
{
   skin = "yellow";
   points = 2;
   referenceColor = "0.9 1 0";
};

datablock ItemData(GemItem_5pts: GemItem) 
{
   skin = "blue";
   points = 5;
   referenceColor = "0 0 0.9";
};