/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

class Skin {
    static boolean skinInitialized;
    static BufferedImage askBubbleFrame;
    static BufferedImage askPointerL;
    static BufferedImage askPointerR;
    static BufferedImage bubbleFrame;
    static BufferedImage goButton;
    static BufferedImage goButtonOver;
    static BufferedImage promptCheckButton;
    static BufferedImage sliderKnob;
    static BufferedImage sliderSlot;
    static BufferedImage stopButton;
    static BufferedImage stopButtonOver;
    static BufferedImage talkPointerL;
    static BufferedImage talkPointerR;
    static BufferedImage thinkPointerL;
    static BufferedImage thinkPointerR;
    static BufferedImage watcherOuterFrame;
    static BufferedImage listWatcherOuterFrame;
    static BufferedImage listWatcherOuterFrameError;
    static BufferedImage vScrollFrame;
    static BufferedImage vScrollSlider;

    Skin() {
    }

    static synchronized void readSkin(Component component) {
        if (skinInitialized) {
            return;
        }
        askBubbleFrame = Skin.readImage("askBubbleFrame.gif", component);
        askPointerL = Skin.readImage("askBubblePointer.gif", component);
        askPointerR = Skin.flipImage(askPointerL);
        bubbleFrame = Skin.readImage("talkBubbleFrame.gif", component);
        goButton = Skin.readImage("goButton.gif", component);
        goButtonOver = Skin.readImage("goButtonOver.gif", component);
        promptCheckButton = Skin.readImage("promptCheckButton.png", component);
        sliderKnob = Skin.readImage("sliderKnob.gif", component);
        sliderSlot = Skin.readImage("sliderSlot.gif", component);
        stopButton = Skin.readImage("stopButton.gif", component);
        stopButtonOver = Skin.readImage("stopButtonOver.gif", component);
        talkPointerL = Skin.readImage("talkBubbleTalkPointer.gif", component);
        talkPointerR = Skin.flipImage(talkPointerL);
        thinkPointerL = Skin.readImage("talkBubbleThinkPointer.gif", component);
        thinkPointerR = Skin.flipImage(thinkPointerL);
        watcherOuterFrame = Skin.readImage("watcherOuterFrame.png", component);
        listWatcherOuterFrame = Skin.readImage("listWacherOuterFrame.png", component);
        listWatcherOuterFrameError = Skin.readImage("listWacherOuterFrameError.png", component);
        vScrollFrame = Skin.readImage("vScrollFrame.png", component);
        vScrollSlider = Skin.readImage("vScrollSlider.png", component);
        skinInitialized = true;
    }

    static BufferedImage readImage(String string, Component component) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(component.getClass().getResource("skin/" + string));
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, null);
        graphics.dispose();
        return bufferedImage;
    }

    static BufferedImage flipImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, n, 0, 0, n2, 0, 0, n, n2, null);
        graphics.dispose();
        return bufferedImage2;
    }
}

