/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

class ObjReader {
    DataInputStream s;
    Object[][] objTable;
    static final int ObjectRefID = 99;
    static final Object[] empty = new Object[0];
    static final Canvas canvas = new Canvas();
    static final byte[] macRomanToISOLatin = new byte[]{-60, -59, -57, -55, -47, -42, -36, -31, -32, -30, -28, -29, -27, -25, -23, -24, -22, -21, -19, -20, -18, -17, -15, -13, -14, -12, -10, -11, -6, -7, -5, -4, -122, -80, -94, -93, -89, -107, -74, -33, -82, -87, -103, -76, -88, -128, -58, -40, -127, -79, -118, -115, -91, -75, -114, -113, -112, -102, -99, -86, -70, -98, -26, -8, -65, -95, -84, -90, -125, -83, -78, -85, -69, -123, -96, -64, -61, -43, -116, -100, -106, -105, -109, -108, -111, -110, -9, -77, -1, -97, -71, -92, -117, -101, -68, -67, -121, -73, -126, -124, -119, -62, -54, -63, -53, -56, -51, -50, -49, -52, -45, -44, -66, -46, -38, -37, -39, -48, -120, -104, -81, -41, -35, -34, -72, -16, -3, -2};
    static final byte[] squeakColors = new byte[]{-1, -1, -1, 0, 0, 0, -1, -1, -1, -128, -128, -128, -1, 0, 0, 0, -1, 0, 0, 0, -1, 0, -1, -1, -1, -1, 0, -1, 0, -1, 32, 32, 32, 64, 64, 64, 96, 96, 96, -97, -97, -97, -65, -65, -65, -33, -33, -33, 8, 8, 8, 16, 16, 16, 24, 24, 24, 40, 40, 40, 48, 48, 48, 56, 56, 56, 72, 72, 72, 80, 80, 80, 88, 88, 88, 104, 104, 104, 112, 112, 112, 120, 120, 120, -121, -121, -121, -113, -113, -113, -105, -105, -105, -89, -89, -89, -81, -81, -81, -73, -73, -73, -57, -57, -57, -49, -49, -49, -41, -41, -41, -25, -25, -25, -17, -17, -17, -9, -9, -9, 0, 0, 0, 0, 51, 0, 0, 102, 0, 0, -103, 0, 0, -52, 0, 0, -1, 0, 0, 0, 51, 0, 51, 51, 0, 102, 51, 0, -103, 51, 0, -52, 51, 0, -1, 51, 0, 0, 102, 0, 51, 102, 0, 102, 102, 0, -103, 102, 0, -52, 102, 0, -1, 102, 0, 0, -103, 0, 51, -103, 0, 102, -103, 0, -103, -103, 0, -52, -103, 0, -1, -103, 0, 0, -52, 0, 51, -52, 0, 102, -52, 0, -103, -52, 0, -52, -52, 0, -1, -52, 0, 0, -1, 0, 51, -1, 0, 102, -1, 0, -103, -1, 0, -52, -1, 0, -1, -1, 51, 0, 0, 51, 51, 0, 51, 102, 0, 51, -103, 0, 51, -52, 0, 51, -1, 0, 51, 0, 51, 51, 51, 51, 51, 102, 51, 51, -103, 51, 51, -52, 51, 51, -1, 51, 51, 0, 102, 51, 51, 102, 51, 102, 102, 51, -103, 102, 51, -52, 102, 51, -1, 102, 51, 0, -103, 51, 51, -103, 51, 102, -103, 51, -103, -103, 51, -52, -103, 51, -1, -103, 51, 0, -52, 51, 51, -52, 51, 102, -52, 51, -103, -52, 51, -52, -52, 51, -1, -52, 51, 0, -1, 51, 51, -1, 51, 102, -1, 51, -103, -1, 51, -52, -1, 51, -1, -1, 102, 0, 0, 102, 51, 0, 102, 102, 0, 102, -103, 0, 102, -52, 0, 102, -1, 0, 102, 0, 51, 102, 51, 51, 102, 102, 51, 102, -103, 51, 102, -52, 51, 102, -1, 51, 102, 0, 102, 102, 51, 102, 102, 102, 102, 102, -103, 102, 102, -52, 102, 102, -1, 102, 102, 0, -103, 102, 51, -103, 102, 102, -103, 102, -103, -103, 102, -52, -103, 102, -1, -103, 102, 0, -52, 102, 51, -52, 102, 102, -52, 102, -103, -52, 102, -52, -52, 102, -1, -52, 102, 0, -1, 102, 51, -1, 102, 102, -1, 102, -103, -1, 102, -52, -1, 102, -1, -1, -103, 0, 0, -103, 51, 0, -103, 102, 0, -103, -103, 0, -103, -52, 0, -103, -1, 0, -103, 0, 51, -103, 51, 51, -103, 102, 51, -103, -103, 51, -103, -52, 51, -103, -1, 51, -103, 0, 102, -103, 51, 102, -103, 102, 102, -103, -103, 102, -103, -52, 102, -103, -1, 102, -103, 0, -103, -103, 51, -103, -103, 102, -103, -103, -103, -103, -103, -52, -103, -103, -1, -103, -103, 0, -52, -103, 51, -52, -103, 102, -52, -103, -103, -52, -103, -52, -52, -103, -1, -52, -103, 0, -1, -103, 51, -1, -103, 102, -1, -103, -103, -1, -103, -52, -1, -103, -1, -1, -52, 0, 0, -52, 51, 0, -52, 102, 0, -52, -103, 0, -52, -52, 0, -52, -1, 0, -52, 0, 51, -52, 51, 51, -52, 102, 51, -52, -103, 51, -52, -52, 51, -52, -1, 51, -52, 0, 102, -52, 51, 102, -52, 102, 102, -52, -103, 102, -52, -52, 102, -52, -1, 102, -52, 0, -103, -52, 51, -103, -52, 102, -103, -52, -103, -103, -52, -52, -103, -52, -1, -103, -52, 0, -52, -52, 51, -52, -52, 102, -52, -52, -103, -52, -52, -52, -52, -52, -1, -52, -52, 0, -1, -52, 51, -1, -52, 102, -1, -52, -103, -1, -52, -52, -1, -52, -1, -1, -1, 0, 0, -1, 51, 0, -1, 102, 0, -1, -103, 0, -1, -52, 0, -1, -1, 0, -1, 0, 51, -1, 51, 51, -1, 102, 51, -1, -103, 51, -1, -52, 51, -1, -1, 51, -1, 0, 102, -1, 51, 102, -1, 102, 102, -1, -103, 102, -1, -52, 102, -1, -1, 102, -1, 0, -103, -1, 51, -103, -1, 102, -103, -1, -103, -103, -1, -52, -103, -1, -1, -103, -1, 0, -52, -1, 51, -52, -1, 102, -52, -1, -103, -52, -1, -52, -52, -1, -1, -52, -1, 0, -1, -1, 51, -1, -1, 102, -1, -1, -103, -1, -1, -52, -1, -1, -1, -1};

    ObjReader(InputStream inputStream) {
        this.s = new DataInputStream(inputStream);
    }

    Object[][] readObjects(LContext lContext) throws IOException {
        this.readInfo();
        this.readObjTable(lContext);
        return this.objTable;
    }

    Hashtable readInfo() throws IOException {
        byte[] byArray = new byte[10];
        this.s.read(byArray);
        if (!"ScratchV01".equals(new String(byArray)) && !"ScratchV02".equals(new String(byArray))) {
            throw new IOException();
        }
        int n = this.s.readInt();
        this.readObjTable(null);
        Object[] objectArray = (Object[])this.objTable[0][0];
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(objectArray.length);
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            hashtable.put(objectArray[i], objectArray[i + 1]);
        }
        return hashtable;
    }

    void readObjTable(LContext lContext) throws IOException {
        byte[] byArray = new byte[4];
        this.s.read(byArray);
        if (!"ObjS".equals(new String(byArray)) || this.s.readByte() != 1) {
            throw new IOException();
        }
        this.s.read(byArray);
        if (!"Stch".equals(new String(byArray)) || this.s.readByte() != 1) {
            throw new IOException();
        }
        int n = this.s.readInt();
        this.objTable = new Object[n][];
        for (int i = 0; i < n; ++i) {
            this.objTable[i] = this.readObj();
        }
        this.createSpritesAndWatchers(lContext);
        this.buildImagesAndSounds();
        this.fixSounds();
        this.resolveReferences();
        this.uncompressMedia();
    }

    Object[] readObj() throws IOException {
        Object[] objectArray;
        int n = this.s.readUnsignedByte();
        if (n < 99) {
            objectArray = new Object[]{this.readFixedFormat(n), new Integer(n)};
        } else {
            int n2 = this.s.readUnsignedByte();
            int n3 = this.s.readUnsignedByte();
            objectArray = new Object[3 + n3];
            objectArray[0] = empty;
            objectArray[1] = new Integer(n);
            objectArray[2] = new Integer(n2);
            for (int i = 3; i < objectArray.length; ++i) {
                objectArray[i] = this.readField();
            }
        }
        return objectArray;
    }

    Object readField() throws IOException {
        int n = this.s.readUnsignedByte();
        if (n == 99) {
            int n2 = this.s.readUnsignedByte() << 16;
            n2 += this.s.readUnsignedByte() << 8;
            return new Ref(n2 += this.s.readUnsignedByte());
        }
        return this.readFixedFormat(n);
    }

    Object readFixedFormat(int n) throws IOException {
        switch (n) {
            case 1: {
                return empty;
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 3: {
                return Boolean.FALSE;
            }
            case 4: {
                return new Integer(this.s.readInt());
            }
            case 5: {
                return new Integer(this.s.readShort());
            }
            case 6: 
            case 7: {
                double d = 0.0;
                double d2 = 1.0;
                int n2 = this.s.readShort();
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.s.readUnsignedByte();
                    d += d2 * (double)n3;
                    d2 *= 256.0;
                }
                if (n == 7) {
                    d = -d;
                }
                return new Double(d);
            }
            case 8: {
                return new Double(this.s.readDouble());
            }
            case 9: 
            case 10: {
                int n4 = this.s.readInt();
                byte[] byArray = new byte[n4];
                this.s.read(byArray);
                for (int i = 0; i < n4; ++i) {
                    if (byArray[i] >= 0) continue;
                    byArray[i] = macRomanToISOLatin[byArray[i] + 128];
                }
                try {
                    return new String(byArray, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(byArray);
                }
            }
            case 11: {
                int n5 = this.s.readInt();
                byte[] byArray = new byte[n5];
                this.s.read(byArray);
                return byArray;
            }
            case 12: {
                int n6 = this.s.readInt();
                byte[] byArray = new byte[2 * n6];
                this.s.read(byArray);
                return byArray;
            }
            case 13: {
                int n7 = this.s.readInt();
                int[] nArray = new int[n7];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.s.readInt();
                }
                return nArray;
            }
            case 14: {
                int n8 = this.s.readInt();
                byte[] byArray = new byte[n8];
                this.s.read(byArray);
                try {
                    return new String(byArray, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return new String(byArray);
                }
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int n9 = this.s.readInt();
                Object[] objectArray = new Object[n9];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.readField();
                }
                return objectArray;
            }
            case 24: 
            case 25: {
                int n10 = this.s.readInt();
                Object[] objectArray = new Object[2 * n10];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = this.readField();
                }
                return objectArray;
            }
            case 30: 
            case 31: {
                int n11 = this.s.readInt();
                int n12 = 255;
                if (n == 31) {
                    n12 = this.s.readUnsignedByte();
                }
                return new Color(n11 >> 22 & 0xFF, n11 >> 12 & 0xFF, n11 >> 2 & 0xFF, n12);
            }
            case 32: {
                Object[] objectArray = new Object[]{this.readField(), this.readField()};
                return objectArray;
            }
            case 33: {
                Object[] objectArray = new Object[]{this.readField(), this.readField(), this.readField(), this.readField()};
                return objectArray;
            }
            case 34: 
            case 35: {
                Object[] objectArray = new Object[6];
                for (int i = 0; i < 5; ++i) {
                    objectArray[i] = this.readField();
                }
                if (n == 35) {
                    objectArray[5] = this.readField();
                }
                return objectArray;
            }
        }
        System.out.println("Unknown fixed-format class " + n);
        throw new IOException();
    }

    void createSpritesAndWatchers(LContext lContext) {
        for (int i = 0; i < this.objTable.length; ++i) {
            Object[] objectArray = this.objTable[i];
            int n = ((Number)objectArray[1]).intValue();
            if (n == 124 || n == 125) {
                objectArray[0] = new Sprite(lContext);
            }
            if (n != 155) continue;
            objectArray[0] = new Watcher(lContext);
            if (((Number)objectArray[2]).intValue() <= 3) continue;
            Number number = (Number)objectArray[23];
            Number number2 = (Number)objectArray[24];
            if (!this.floatWithoutFraction(number) && !this.floatWithoutFraction(number2)) continue;
            objectArray[24] = new Double(number2.doubleValue() + 1.0E-8);
        }
    }

    boolean floatWithoutFraction(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = (Double)object;
        return (double)Math.round(d) == d;
    }

    void resolveReferences() throws IOException {
        for (int i = 0; i < this.objTable.length; ++i) {
            int n = ((Number)this.objTable[i][1]).intValue();
            if (n >= 20 && n <= 29) {
                Object[] objectArray = (Object[])this.objTable[i][0];
                for (int j = 0; j < objectArray.length; ++j) {
                    Object object = objectArray[j];
                    if (!(object instanceof Ref)) continue;
                    objectArray[j] = this.deRef((Ref)object);
                }
            }
            if (n <= 99) continue;
            for (int j = 3; j < this.objTable[i].length; ++j) {
                Object object = this.objTable[i][j];
                if (!(object instanceof Ref)) continue;
                this.objTable[i][j] = this.deRef((Ref)object);
            }
        }
    }

    Object deRef(Ref ref) {
        Object[] objectArray = this.objTable[ref.index];
        return objectArray[0] == null || objectArray[0] == empty ? objectArray : objectArray[0];
    }

    void buildImagesAndSounds() throws IOException {
        for (int i = 0; i < this.objTable.length; ++i) {
            Object[] objectArray;
            int n = ((Number)this.objTable[i][1]).intValue();
            if (n == 34 || n == 35) {
                Object object;
                Object object2;
                objectArray = (Object[])this.objTable[i][0];
                int n2 = ((Number)objectArray[0]).intValue();
                int n3 = ((Number)objectArray[1]).intValue();
                int n4 = ((Number)objectArray[2]).intValue();
                int[] nArray = this.decodePixels(this.objTable[((Ref)objectArray[4]).index][0]);
                MemoryImageSource memoryImageSource = null;
                this.objTable[i][0] = empty;
                if (n4 <= 8) {
                    if (objectArray[5] != null) {
                        object2 = (Object[])this.objTable[((Ref)objectArray[5]).index][0];
                        object = this.customColorMap(n4, (Object[])object2);
                    } else {
                        object = this.squeakColorMap(n4);
                    }
                    memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)object, this.rasterToByteRaster(nArray, n2, n3, n4), 0, n2);
                }
                if (n4 == 16) {
                    memoryImageSource = new MemoryImageSource(n2, n3, this.raster16to32(nArray, n2, n3), 0, n2);
                }
                if (n4 == 32) {
                    memoryImageSource = new MemoryImageSource(n2, n3, this.rasterAddAlphaTo32(nArray), 0, n2);
                }
                if (memoryImageSource != null) {
                    object = new int[n2 * n3];
                    object2 = new PixelGrabber(memoryImageSource, 0, 0, n2, n3, (int[])object, 0, n2);
                    try {
                        ((PixelGrabber)object2).grabPixels();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                    bufferedImage.getRaster().setDataElements(0, 0, n2, n3, object);
                    this.objTable[i][0] = bufferedImage;
                }
            }
            if (n != 109) continue;
            objectArray = this.objTable[((Ref)this.objTable[i][6]).index];
            this.objTable[i][0] = new ScratchSound(((Number)this.objTable[i][7]).intValue(), (byte[])objectArray[0]);
        }
    }

    int[] decodePixels(Object object) throws IOException {
        if (object instanceof int[]) {
            return (int[])object;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
        int n = this.decodeInt(dataInputStream);
        int[] nArray = new int[n];
        int n2 = 0;
        while (dataInputStream.available() > 0 & n2 < n) {
            int n3 = this.decodeInt(dataInputStream);
            int n4 = n3 >> 2;
            int n5 = n3 & 3;
            switch (n5) {
                case 0: {
                    n2 += n4;
                    break;
                }
                case 1: {
                    int n6;
                    int n7 = dataInputStream.readUnsignedByte();
                    int n8 = n7 << 24 | n7 << 16 | n7 << 8 | n7;
                    for (n6 = 0; n6 < n4; ++n6) {
                        nArray[n2++] = n8;
                    }
                    break;
                }
                case 2: {
                    int n6;
                    int n8 = dataInputStream.readInt();
                    for (n6 = 0; n6 < n4; ++n6) {
                        nArray[n2++] = n8;
                    }
                    break;
                }
                case 3: {
                    int n6;
                    int n8;
                    for (n6 = 0; n6 < n4; ++n6) {
                        n8 = dataInputStream.readUnsignedByte() << 24;
                        n8 |= dataInputStream.readUnsignedByte() << 16;
                        n8 |= dataInputStream.readUnsignedByte() << 8;
                        nArray[n2++] = n8 |= dataInputStream.readUnsignedByte();
                    }
                    break;
                }
            }
        }
        return nArray;
    }

    int decodeInt(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n <= 223) {
            return n;
        }
        if (n <= 254) {
            return (n - 224) * 256 + dataInputStream.readUnsignedByte();
        }
        return dataInputStream.readInt();
    }

    int[] rasterAddAlphaTo32(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == 0) continue;
            nArray[i] = 0xFF000000 | n;
        }
        return nArray;
    }

    int[] raster16to32(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n * n2];
        int n3 = (n + 1) / 2;
        for (int i = 0; i < n2; ++i) {
            int n4 = 16;
            for (int j = 0; j < n; ++j) {
                int n5;
                int n6 = nArray[i * n3 + j / 2] >> n4 & 0xFFFF;
                int n7 = (n6 >> 10 & 0x1F) << 3;
                int n8 = (n6 >> 5 & 0x1F) << 3;
                int n9 = (n6 & 0x1F) << 3;
                nArray2[i * n + j] = n5 = n7 + n8 + n9 == 0 ? 0 : 0xFF000000 | n7 << 16 | n8 << 8 | n9;
                n4 = n4 == 16 ? 0 : 16;
            }
        }
        return nArray2;
    }

    byte[] rasterToByteRaster(int[] nArray, int n, int n2, int n3) {
        byte[] byArray = new byte[n * n2];
        int n4 = nArray.length / n2;
        int n5 = (1 << n3) - 1;
        int n6 = 32 / n3;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7 = nArray[i * n4 + j / n6];
                int n8 = n3 * (n6 - j % n6 - 1);
                byArray[i * n + j] = (byte)(n7 >> n8 & n5);
            }
        }
        return byArray;
    }

    IndexColorModel squeakColorMap(int n) {
        int n2 = n == 1 ? -1 : 0;
        return new IndexColorModel(n, 256, squeakColors, 0, false, n2);
    }

    IndexColorModel customColorMap(int n, Object[] objectArray) {
        byte[] byArray = new byte[4 * objectArray.length];
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Color color = (Color)this.objTable[((Ref)objectArray[i]).index][0];
            byArray[n2++] = (byte)color.getRed();
            byArray[n2++] = (byte)color.getGreen();
            byArray[n2++] = (byte)color.getBlue();
            byArray[n2++] = (byte)color.getAlpha();
        }
        return new IndexColorModel(n, objectArray.length, byArray, 0, true, 0);
    }

    void fixSounds() {
        int n;
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < this.objTable.length; ++n2) {
            n = ((Number)this.objTable[n2][1]).intValue();
            if (n != 109 || !((ScratchSound)this.objTable[n2][0]).isByteReversed()) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        for (n2 = 0; n2 < this.objTable.length; ++n2) {
            n = ((Number)this.objTable[n2][1]).intValue();
            if (n != 109) continue;
            ((ScratchSound)this.objTable[n2][0]).reverseBytes();
        }
    }

    void uncompressMedia() {
        for (int i = 0; i < this.objTable.length; ++i) {
            Object[] objectArray = this.objTable[i];
            int n = ((Number)objectArray[1]).intValue();
            int n2 = -1;
            if (n >= 100) {
                n2 = ((Number)objectArray[2]).intValue();
            }
            if (n == 162 && n2 >= 4) {
                BufferedImage bufferedImage;
                if (objectArray[7] instanceof byte[] && (bufferedImage = this.jpegDecode((byte[])objectArray[7])) != null) {
                    if (objectArray[4] instanceof Image) {
                        ((Image)objectArray[4]).flush();
                    }
                    objectArray[4] = bufferedImage;
                    objectArray[7] = empty;
                }
                if (objectArray[8] instanceof BufferedImage) {
                    objectArray[4] = objectArray[8];
                    objectArray[8] = empty;
                }
            }
            if (n != 164 || n2 < 2 || !(objectArray[9] instanceof byte[])) continue;
            int n3 = ((Number)objectArray[7]).intValue();
            int n4 = ((Number)objectArray[8]).intValue();
            byte[] byArray = (byte[])objectArray[9];
            int n5 = (byArray.length * 8 + (n4 - 1)) / n4;
            int[] nArray = new ADPCMDecoder(byArray, n4).decode(n5);
            objectArray[4] = new ScratchSound(n3, nArray);
            objectArray[9] = empty;
            objectArray[7] = objectArray[8] = empty;
        }
    }

    void canonicalizeMedia() {
        Vector vector = new Vector(100);
        Vector vector2 = new Vector(100);
        for (int i = 0; i < this.objTable.length; ++i) {
            Object object;
            Object[] objectArray = this.objTable[i];
            int n = ((Number)objectArray[1]).intValue();
            if (n == 162) {
                object = (BufferedImage)objectArray[4];
            }
            if (n != 164) continue;
            object = (ScratchSound)objectArray[4];
        }
    }

    BufferedImage jpegDecode(byte[] byArray) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(byArray);
        MediaTracker mediaTracker = new MediaTracker(canvas);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, null);
        graphics.dispose();
        image.flush();
        return bufferedImage;
    }

    void printit(Object object) {
        if (object instanceof Object[] && ((Object[])object).length == 0) {
            System.out.print(" []");
            return;
        }
        if (object instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)object;
            System.out.print(" BufferedImage_" + object.hashCode() + "(" + bufferedImage.getWidth(null) + "x" + bufferedImage.getHeight(null) + ")");
            return;
        }
        System.out.print(" " + object);
    }
}

