//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
// Portions Copyright (c) 2001 by Sierra Online, Inc.
//-----------------------------------------------------------------------------

// Normally the trigger class would be sub-classed to support different
// functionality, but we're going to use the name of the trigger instead
// as an experiment.

//-----------------------------------------------------------------------------

datablock TriggerData(InBoundsTrigger)
{
   tickPeriodMS = 100;
};

function InBoundsTrigger::onLeaveTrigger(%this,%trigger,%obj)
{
   // Leaving an in bounds area.
   %obj.getDatablock().onOutOfBounds(%obj);
}


//-----------------------------------------------------------------------------

datablock TriggerData(OutOfBoundsTrigger)
{
   tickPeriodMS = 100;
};

function OutOfBoundsTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // Entering an out of bounds area
   %obj.getDatablock().onOutOfBounds(%obj);
}

//-----------------------------------------------------------------------------

datablock TriggerData(HelpTrigger)
{
   tickPeriodMS = 100;
};

function HelpTrigger::onEnterTrigger(%this,%trigger,%obj)
{
   // Leaving an in bounds area.
   addHelpLine(%trigger.text, true);
}
datablock TriggerData(TeleportTrigger)
{
   tickPeriodMS = 500;
};
datablock AudioProfile(TeleportBuzz)
{
   fileName = "~/data/sound/teleport.wav";
   description = AudioClose3d;
	preload = true;
};

function TeleportTrigger::onEnterTrigger(%data, %obj, %colObj)
{
   %checkname = %obj.getName();
   %client = %colObj.client;
   if(!%client)
   {
      echo("not a client!");
      return;
   }
   echo("Teleport client:" SPC %client);

   if(%checkname $= "TeleportTrigger1")
   {
      if(!$from2to1)
      {
         %target = "TeleportTrigger2";
         CommandToClient(%client,'bottomprint',"Teleport Activated",2,10);
         $teleSched = schedule(2000,0,"goScotty",%client,%target);
        	$teleSound = serverPlay3D(TeleportBuzz,%client.player.getTransform());
         %client.player.setCloaked(true);
         $from1to2 = true;
         $from2to1 = false;
      }
   }
   else
   {
      if(!$from1to2)
      {
         %target = "TeleportTrigger1";
         CommandToClient(%client,'bottomprint',"Teleporter Activated",2,10);
         $teleSched = schedule(2000,0,"goScotty",%client, %target);
        	$teleSound = serverPlay3D(TeleportBuzz,%client.player.getTransform());
         %client.player.setCloaked(true);
         $from2to1 = true;
         $from1to2 = false;
      }
   }
}

function TeleportTrigger::onLeaveTrigger(%data, %obj, %colObj)
{
   %checkname = %obj.getName();
   %client = %colObj.client;
   echo("TeleportTrigger::onLeaveTrigger called!");
   cancel($teleSched);
   alxStop($teleSound);
   %client.player.setCloaked(false);
   // if the player leaves the target trigger,
   // he can use it, too...
   if(%checkname $= "TeleportTrigger1")
   {
      $from2to1 = false;
   }
   else if(%checkname $= "TeleportTrigger2")
   {
      $from1to2 = false;
   }
}
function goScotty(%client, %target)
{
   echo("goScotty called!");
   // beam me up!
   commandToServer('TeleportPlayer', %client, %target);
}
function TeleportTrigger::onTickTrigger(%data, %obj)
{
}
