//-----------------------------------------------------------------------------
// Torque Game Engine
//
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------

new MaterialProperty(DefaultMaterial) {
   friction = 1;
   restitution = 1;
   force = 0;
};


// Will need to play with these three friction values to balance game play
new MaterialProperty(NoFrictionMaterial) {
   friction = 0.01;
   restitution = 0.5;
};

new MaterialProperty(LowFrictionMaterial) {
   friction = 0.20;
   restitution = 0.5;
};

new MaterialProperty(HighFrictionMaterial) {
   friction = 1.50;
   restitution = 0.5;
};

new MaterialProperty(VeryHighFrictionMaterial) {
   friction = 2;
   restitution = 1;
};



new MaterialProperty(RubberFloorMaterial) {
   friction = 1;
   restitution = 1;
};

new MaterialProperty(IceMaterial) {
   friction = 0.05;
   restitution = 0.5;
};

new MaterialProperty(BumperMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 15;
};

new MaterialProperty(ButtonMaterial) {
   friction = 1;
   restitution = 1;
};

new MaterialProperty(LowBounceFloorMaterial) {
   friction = 1;
   restitution = 1;
   force = 5;
};

new MaterialProperty(MedBounceFloorMaterial) {
   friction = 1;
   restitution = 1;
   force = 10;
};

new MaterialProperty(HighBounceFloorMaterial) {
   friction = 1;
   restitution = 1;
   force = 15;
};

new MaterialProperty(GrassFrictionMaterial) {
   friction = 1.50;
   restitution = 0.35;
};

new MaterialProperty(TarmacFrictionMaterial) {
   friction = 0.85;
   restitution = 0.9;
};

new MaterialProperty(RugFrictionMaterial) {
   friction = 6;
   restitution = 0.5;
};

new MaterialProperty(IceFrictionMaterial) {
   friction = 0.03;
   restitution = 0.95;
};

new MaterialProperty(CarpetFrictionMaterial) {
   friction = 6;
   restitution = 0.5;
};

new MaterialProperty(SandFrictionMaterial) {
   friction = 4;
   restitution = 0.1;
};

new MaterialProperty(WaterFrictionMaterial) {
   friction = 6;
   restitution = 0;
};

new MaterialProperty(BounceyFrictionMaterial) {
   friction = 0.2;
   restitution = 0;
   force = 15;
};

new MaterialProperty(BackwardsForceMaterial) {
   friction = -1;
   restitution = 1;
};

new MaterialProperty(NoFrictionMaterial) {
   friction = 0.01;
   restitution = 0.5;
};

new MaterialProperty(LowFrictionMaterial) {
   friction = 0.20;
   restitution = 0.5;
};

new MaterialProperty(HighFrictionMaterial) {
   friction = 1.50;
   restitution = 0.5;
};

new MaterialProperty(VeryHighFrictionMaterial) {
   friction = 2;
   restitution = 1;
};

new MaterialProperty(TrampolineFloor) {
   friction = 1;
   restitution = 3;
};

new MaterialProperty(NeverStopBounceFloor) {
   friction = 1;
   restitution = 2;
};

new MaterialProperty(SafeFallFloor) {
   friction = 1;
   restitution = 0;
};

new MaterialProperty(BumperFloor1) {
   friction = 1;
   restitution = 0;
   force = 5;
};

new MaterialProperty(BumperFloor2) {
   friction = 1;
   restitution = 0;
   force = 10;
};

new MaterialProperty(BumperFloor3) {
   friction = 1;
   restitution = 0;
   force = 15;
};

new MaterialProperty(RubberFloorMaterial) {
   friction = 1;
   restitution = 1;
};

new MaterialProperty(IceMaterial) {
   friction = 0.05;
   restitution = 0.5;
};

new MaterialProperty(BumperMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 15;
};

new MaterialProperty(ButtonMaterial) {
   friction = 1;
   restitution = 1;
};

new MaterialProperty(LowBounceMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 8;
};

new MaterialProperty(NormalBounceMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 15;
};

new MaterialProperty(HighBounceMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 30;
};

new MaterialProperty(VeryHighBounceMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 45;
};

new MaterialProperty(CarpetMaterial) {
   friction = 3;
   restitution = 0.2;
};

new MaterialProperty(GrassMaterial) {
   friction = 1.5;
   restitution = 0.2;
};

new MaterialProperty(SnowMaterial) {
   friction = 0.5;
   restitution = 0.1;
};

new MaterialProperty(WaterMaterial) {
   friction = 1;
   restitution = 0;
};

new MaterialProperty(SteelMaterial) {
   friction = 2;
   restitution = 0.5;
};

new MaterialProperty(GlassMaterial) {
   friction = 0.2;
   restitution = 1;
};

new MaterialProperty(JellyMaterial) {
   friction = 0.5;
   restitution = 0;
	force = 2;
};

new MaterialProperty(SandMaterial) {
   friction = 1.5;
   restitution = 0;
};


//
addMaterialMapping( "", DefaultMaterial);

// Textures listed in BrianH texture document
addMaterialMapping( "grid_warm" ,    DefaultMaterial);
addMaterialMapping( "grid_cool" ,    DefaultMaterial);
addMaterialMapping( "grid_neutral" , DefaultMaterial);

addMaterialMapping( "stripe_cool" ,    DefaultMaterial);
addMaterialMapping( "stripe_neutral" , DefaultMaterial);
addMaterialMapping( "stripe_warm" ,    DefaultMaterial);
addMaterialMapping( "tube_cool" ,      DefaultMaterial);
addMaterialMapping( "tube_neutral" ,   DefaultMaterial);
addMaterialMapping( "tube_warm" ,      DefaultMaterial);

addMaterialMapping( "solid_cool1" ,      DefaultMaterial);
addMaterialMapping( "solid_cool2" ,      DefaultMaterial);
addMaterialMapping( "solid_neutral1" ,   DefaultMaterial);
addMaterialMapping( "solid_neutral2" ,   DefaultMaterial);
addMaterialMapping( "solid_warm1" ,      DefaultMaterial);
addMaterialMapping( "solid_warm2" ,      DefaultMaterial);

addMaterialMapping( "pattern_cool1" ,      DefaultMaterial);
addMaterialMapping( "pattern_cool2" ,      DefaultMaterial);
addMaterialMapping( "pattern_neutral1" ,   DefaultMaterial);
addMaterialMapping( "pattern_neutral2" ,   DefaultMaterial);
addMaterialMapping( "pattern_warm1" ,      DefaultMaterial);
addMaterialMapping( "pattern_warm2" ,      DefaultMaterial);

addMaterialMapping( "friction_none" ,    NoFrictionMaterial);
addMaterialMapping( "friction_none2" ,    NoFrictionMaterial);
addMaterialMapping( "friction_low" ,     LowFrictionMaterial);
addMaterialMapping( "friction_low2" ,     IceMaterial);
addMaterialMapping( "friction_high" ,    HighFrictionMaterial);
// used for ramps in escher level
addMaterialMapping( "friction_ramp_yellow" ,    VeryHighFrictionMaterial);

// old textures (to be removed?)
addMaterialMapping( "grid1" , RubberFloorMaterial);
addMaterialMapping( "grid2" , RubberFloorMaterial);
addMaterialMapping( "grid3" , RubberFloorMaterial);
addMaterialMapping( "grid4" , RubberFloorMaterial);

             addMaterialMapping( "Bounce1" , LowBounceFloorMaterial);
             addMaterialMapping( "Bounce2" , MedBounceFloorMaterial);
             addMaterialMapping( "Bounce3" , HighBounceFloorMaterial);
			 
addMaterialMapping( "grass" , GrassFrictionMaterial);
addMaterialMapping( "ice1" , IceFrictionMaterial);
addMaterialMapping( "rug" ,    RugFrictionMaterial);
addMaterialMapping( "tarmac" ,    TarmacFrictionMaterial);
addMaterialMapping( "carpet" ,    CarpetFrictionMaterial);
addMaterialMapping( "sand" ,    SandFrictionMaterial);
addMaterialMapping( "water" ,    WaterFrictionMaterial);
addMaterialMapping( "floor_bounce" ,    BounceyFrictionMaterial);
addMaterialMapping( "mbp_chevron_friction" ,    BackwardsForceMaterial);
addMaterialMapping( "mbp_chevron_friction2" ,    BackwardsForceMaterial);
addMaterialMapping( "mbp_chevron_friction3" ,    BackwardsForceMaterial);

// some part textures
addMaterialMapping( "oilslick" , IceMaterial);
addMaterialMapping( "base.slick" , IceMaterial);
addMaterialMapping( "ice.slick" , IceMaterial);
addMaterialMapping( "bumper-rubber" ,    BumperMaterial);
addMaterialMapping( "triang-side" ,      BumperMaterial);
addMaterialMapping( "triang-top" ,      BumperMaterial);
addMaterialMapping( "pball-round-side" , BumperMaterial);
addMaterialMapping( "pball-round-top" , BumperMaterial);
addMaterialMapping( "pball-round-bottm" , BumperMaterial);
addMaterialMapping( "button" , ButtonMaterial);

addMaterialMapping( "friction_none" ,    NoFrictionMaterial);
addMaterialMapping( "friction_low" ,     LowFrictionMaterial);
addMaterialMapping( "friction_high" ,    HighFrictionMaterial);
// used for ramps in escher level
addMaterialMapping( "friction_ramp_yellow" ,    VeryHighFrictionMaterial);

// old textures (to be removed?)
addMaterialMapping( "grid1" , RubberFloorMaterial);
addMaterialMapping( "grid2" , RubberFloorMaterial);
addMaterialMapping( "grid3" , RubberFloorMaterial);
addMaterialMapping( "grid4" , RubberFloorMaterial);

// some part textures
addMaterialMapping( "oilslick" , IceMaterial);
addMaterialMapping( "base.slick" , IceMaterial);
addMaterialMapping( "ice.slick" , IceMaterial);
addMaterialMapping( "bumper-rubber" ,    BumperMaterial);
addMaterialMapping( "triang-side" ,      BumperMaterial);
addMaterialMapping( "triang-top" ,      BumperMaterial);
addMaterialMapping( "pball-round-side" , BumperMaterial);
addMaterialMapping( "pball-round-top" , BumperMaterial);
addMaterialMapping( "pball-round-bottm" , BumperMaterial);
addMaterialMapping( "button" , ButtonMaterial);

// some custom floors
addMaterialMapping( "carpet",  CarpetMaterial);
addMaterialMapping( "blah",  LowBounceMaterial);
addMaterialMapping( "mmg_ice",  IceMaterial);
addMaterialMapping( "mmg_grass",  GrassMaterial);
addmaterialMapping( "mmg_jelly",  JellyMaterial);
addMaterialMapping( "mmg_sand",  SandMaterial);
addMaterialMapping( "mmg_water",  WaterMaterial);
addMaterialMapping( "water",  Watermaterial);
addMaterialMapping( "snow",  SnowMaterial);
addMaterialMapping( "steel",  SteelMaterial);

// bumper floors
addMaterialMapping( "floor_bounce_low",  LowBounceMaterial);
addMaterialMapping( "floor_bounce",  NormalBounceMaterial);
addMaterialMapping( "floor_bounce_high",  HighBounceMaterial);
addMaterialMapping( "floor_bounce_very_high",  VeryHighBounceMaterial);
$testcheats=1;