//-----------------------------------------------------------------------------
// Torque Game Engine
//
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Gem base class
//-----------------------------------------------------------------------------

datablock AudioProfile(GotGemSfx)
{
   filename    = "~/data/sound/gotGem.wav";
   description = Audio2D;
   preload = true;
};

datablock AudioProfile(GotAllGemsSfx)
{
   filename    = "~/data/sound/gotAllGems.wav";
   description = Audio2D;
   preload = true;
};


//-----------------------------------------------------------------------------

$GemSkinColors[0] = "base";

function Gem::onAdd(%this,%obj)
{
   if (%this.skin !$= "")
      %obj.setSkinName(%this.skin);
   else {
      // Random skin if none assigned
      %obj.setSkinName($GemSkinColors[0]);
   }
}

function Gem::onPickup(%this,%obj,%user,%amount)
{
   Parent::onPickup(%this,%obj,%user,%amount);
   %user.client.onFoundGem(%amount);
   return true;
}

function Gem::saveState(%this,%obj,%state)
{
   %state.object[%obj.getId()] = %obj.isHidden();
}

function Gem::restoreState(%this,%obj,%state)
{
   %obj.hide(%state.object[%obj.getId()]);
}

//-----------------------------------------------------------------------------

datablock ItemData(GemItem)
{
   // Mission editor category
   category = "Gems";
   className = "Gem";

   // Basic Item properties
   shapeFile = "~/data/shapes/items/gem.dts";
   mass = 1;
   friction = 1;
   elasticity = 0.3;

   // Dynamic properties defined by the scripts
   pickupName = "a gem!";
   maxInventory = 1;
   noRespawn = true;
   gemType = 1;
   noPickupMessage = true;

   cubeMapped = true;
   noRenderTranslucents = true;
   
   scaleFactor = 1.5;

   textureName = "~/data/textures/gemAura";
};

datablock ItemData(GemItemBlue: GemItem) 
{
   skin = "base";
};

datablock ItemData(GemItemRed: GemItem)
{
   skin = "base";
};

datablock ItemData(GemItemYellow: GemItem)
{
   skin = "base";
};

datablock ItemData(GemItemPurple: GemItem)
{
   skin = "base";
};

datablock ItemData(GemItemGreen: GemItem)
{
   skin = "base";
};

datablock ItemData(GemItemTurquoise: GemItem)
{
   skin = "base";
};

datablock ItemData(GemItemOrange: GemItem)
{
   skin = "base";
};

datablock ItemData(GemItemBlack: GemItem)
{
   skin = "base";
};
