datablock ItemData(EasterEggItem)
{
   // Mission editor category
   category = "Easter";
   className = "EasterEgg";

   // Basic Item properties
   shapeFile = "~/data/shapes/items/egg.dts";
   mass = 1;
   friction = 1;
   elasticity = 0.3;

   // Dynamic properties defined by the scripts
   pickupName = $Text::AnEasterEgg;
   maxInventory = 1;
   noRespawn = true;
   gemType = 1;
   noPickupMessage = false;

   cubeMapped = false;
   noRenderTranslucents = true;
};

function EasterEgg::onPickup(%this,%obj,%user,%amount)
{
   Parent::onPickup(%this,%obj,%user,%amount);
   onEasterEggPickup(%obj.easterEggIndex);
   return true;
}

function EasterEgg::saveState(%this,%obj,%state)
{
   %state.object[%obj.getId()] = %obj.isHidden();
}

function EasterEgg::restoreState(%this,%obj,%state)
{
   %obj.hide(%state.object[%obj.getId()]);
}


function onEasterEggPickup( %index )
{
   if( isDemoLaunch() )
   {
      serverPlay2d(easterNotNewSfx);
      addHelpLine( $Text::DemoEgg, false );
      return;
   }
   
   %me = new LeaderboardEntry();
   %me.loadThisPlayer();
   
   if( %me.hasFoundEgg( %index ) )
   {
      serverPlay2d(easterNotNewSfx);
      addHelpLine( $Text::AlreadyFoundEgg, false );
   }
   else
   {
      // No Dean scream...whatever guys
      //serverPlay2d(easterNewSfx);
      serverPlay2d(GotGemSfx);
      addHelpLine( $Text::FoundNewEgg, false );
      XAFoundEgg( %index );
      XAResetLeaderboards();
   }
}
