//------------------------------------------------------------------------------
// Localization support scripts
//------------------------------------------------------------------------------

function loadLocaleInf(%filename)
{
   echo("Loading Locale Inf file:" SPC %filename);
   %fo = new FileObject();
   
   if (!%fo.openForRead(%filename))
   {
      error("   File not found:" SPC %filename);
      %fo.delete();
      return;
   }
   
   while(!%fo.isEOF())
   {
      %line = %fo.readLine();
      %line = trim(%line);
      
      // if the line is empty, ignore
      if (%line $= "")
         continue;
         
      // if its a section header, ignore
      if (startswith(%line, "[") && endswith(%line, "]"))
         continue;
      
      // if its a comment, ignore
      if (startswith(%line, ";"))
         continue;
         
      // chop off anything after the last semicolon (treat it as a comment)
      %semiPos = strrchrpos(%line, ";");
      
      if (%semiPos != -1)
         %line = getSubStr(%line, 0, %semiPos + 1); // + 1 includes the semicolon
      
      // it should now be a valid "$var = value" torquescript string...but we'll give them some slack if they
      // are missing a semicolon
      if (!endswith(%line, ";"))
         %line = %line @ ";";
         
      // eval it
      //error("eval:" SPC %line);
      %result = eval(%line);
      if (%result $= "")
         outputdebugline("   Script Error:" SPC %line);
   }
   
   %fo.delete();
}

outputdebugline( "WARNING: LOCALIZATION DEBUG BUILD, DO NOT SHIP" );
loadLocaleInf("marble/local/" @ getLanguage() @ "Strings.inf"); 
