//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Override base controls
GuiButtonProfile.soundButtonOver = AudioButtonOver;
GuiButtonProfile.soundButtonDown = AudioButtonDown;
GuiButtonProfile.tab = true;
GuiButtonProfile.canKeyFocus = true;
GuiDefaultProfile.soundButtonDown = AudioButtonDown;
//-----------------------------------------------------------------------------
// Chat Hud profiles

new GuiControlProfile ("ChatHudMessageProfile")
{
   fontType = "Arial";
   fontSize = 16;
   fontColor = "235 235 0";      // default color (death msgs, scoring, inventory)
   fontColors[1] = "4 235 105";   // client join/drop, tournament mode
   fontColors[2] = "219 200 128"; // gameplay, admin/voting, pack/deployable
   fontColors[3] = "77 235 95";   // team chat, spam protection message, client tasks
   fontColors[4] = "40 231 235";  // global chat
   fontColors[5] = "200 200 50 200";  // used in single player game
   // WARNING! Colors 6-9 are reserved for name coloring 
   autoSizeWidth = true;
   autoSizeHeight = true;
};

new GuiControlProfile ("GuiTPTextEditProfile")
{
   opaque = false;
   fillColor = "235 235 235";
   fillColorHL = "128 128 128";
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   fontColorHL = "235 235 235";
   fontColorNA = "128 128 128";
   textOffset = "0 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
};
new GuiControlProfile ("OverlayScreenProfile")
{
   opaque = true;
   fillColor = "0 0 0 96";
   fillColorHL = "128 128 128";
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   fontColorHL = "235 235 235";
   fontColorNA = "128 128 128";
   textOffset = "0 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
};
new GuiControlProfile ("GuiBigTextEditProfile")
{
   fontType = "DomCasualD";
   fontSize = 32;
   opaque = false;
   fillColor = "235 235 235";
   fillColorHL = "128 128 128";
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   fontColorHL = "235 235 235";
   fontColorNA = "128 128 128";
   textOffset = "0 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
};
new GuiControlProfile ("BevelPurpleProfile")
{
   // fill color
   opaque = true;
   border = 2;
   fillColor   = "161 150 229";
   fillColorHL = "235 0 0";
   fillColorNA = "0 0 235";
   // border color
   borderColor   = "0 235 0";
   borderColorNA = "92 86 131";
   textOffset = "6 6";
};

new GuiControlProfile ("HudTextProfile")
{
   opaque = false;
   fillColor = "128 128 128";
   fontColor = "0 255 0";
   border = true;
   borderColor = "0 235 0";
};

//-----------------------------------------------------------------------------
// Center and bottom print
new GuiControlProfile ("CenterPrintProfile")
{
   opaque = false;
   fillColor = "128 128 128";
   fontColor = "0 235 0";
   border = true;
   borderColor = "0 235 0";
};
new GuiControlProfile ("CenterPrintTextProfile")
{
   opaque = false;
   fontType = "Arial";
   fontSize = 12;
   fontColor = "0 235 0";
};

new GuiControlProfile ("TextTitleProfile")
{
   fontType = "Expo";
   fontSize = 42;
   justify = center;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "235 205 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextTitleBackgroundProfile")
{
   fontType = "Expo";
   fontSize = 42;
   justify = center;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextSmallTitleProfile")
{
   fontType = "Expo";
   fontSize = 36;
   justify = center;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "235 205 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextSmallTitleBackgroundProfile")
{
   fontType = "Expo";
   fontSize = 36;
   justify = center;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextHeadingProfile")
{
   fontType = "DomCasualD";
   fontSize = 32;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextHeadingSmallProfile")
{
   fontType = "DomCasualD";
   fontSize = 24;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextHeadingWhiteProfile")
{
   fontType = "DomCasualD";
   fontSize = 32;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "235 235 235";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextHeadingYellowProfile")
{
   fontType = "DomCasualD";
   fontSize = 32;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "235 205 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextListProfile")
{
   fontType = "Arial Bold";
   fontSize = 18;
   justify = left;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   autoSizeWidth = false;
};

new GuiControlProfile ("TextListRightProfile")
{
   fontType = "Arial Bold";
   fontSize = 18;
   justify = right;
   opaque = false;
   border = false;
   borderColor = "16 16 16";
   fontColor = "16 16 16";
   autoSizeWidth = false;
};