//-----------------------------------------------------------------------------
// These scripts handle the locking/unlocking and insert/removal handlers for
// the XBox controlers to fid the certification requirements
//-----------------------------------------------------------------------------

function lockedControlerRemoved()
{
   echo( "--lockedControlerRemoved()" );
   $LockedControlerId = getLockedControler();
   
   $LockedControlerRemoved = true;
   Canvas.pushDialog(ErrorUnplugGui, 100);
   UIXOverlayGui.killUIX();
   
   if( !$gamePaused )
   {
      pauseGame();
   }
}

//------------------------------------------------------------------------------

function lockedControlerReplaced()
{
   echo( "--lockedControlerReplaced()" );
   
   $LockedControlerRemoved = false;
   
   Canvas.popDialog(ErrorUnplugGui);
   $ControlerRemovedDuringLoad = false;
   
   // Messy stupid hack so that UIX can't recieve input for N  seconds after a 
   // controler disconnect message is dismissed, so that if a UIX screen is up
   // behind it, it doesn't get dismissed when they press start
   startLockTimeout();
}

//-----------------------------------------------------------------------------

function onControlerInsert( %controlerId )
{
   if( $LockedControlerRemoved && %controlerId == $LockedControlerId  )
   {
      echo( "Locked controler replaced! Port " @ %controlerId );
      $ControlerRemovedDuringLoad = false;
   }
}

//-----------------------------------------------------------------------------

$LoadingDone = true;

function onControlerRemove( %controlerId )
{
   echo( "==Controler " @ %controlerId @ " removed, controler " @ getLockedControler() @ " is locked. " @ GetNumActiveGamepads() @ " active gamepads." );
   echo( "==State of $LockedControlerRemoved: " @ $LockedControlerRemoved );
   
   // if( $playingDemo )
   // {
      // $ControlerPullDuringDemo = %controlerId + 1;
      // return;
   // }
   
   if( %controlerId == getLockedControler() && %controlerId > -1 )
   {
      if( $LoadingDone )
      {
         if( $PresentationIsDone )
            lockedControlerRemoved();
      }
      else
      {
         $ControlerRemovedDuringLoad = true;
      }
   }
   else if( ( GetNumActiveGamepads() < 1 && $LockedControlerRemoved !$= true )  )
   {
      if( $PresentationIsDone )
      {
         if( $LoadingDone )
         {
            $LockedControlerRemoved = true;
            Canvas.pushDialog(ErrorUnplugGui, 100);
            EU_error_text.setText( $Text::ReconnectAnyPort );
            UIXOverlayGui.killUIX();
         }
         else
         {
            $ControlerRemovedDuringLoad = true;
         }
      }
   }
   else if( getLockedControler() == -2 )
   {
      // Ok, put this off for 1/2 second and see if the sign-on controler was the one it was killing
      schedule( 500, 0, onControlerRemove, %controlerId );
   }
}

//------------------------------------------------------------------------------

// Any time someone finishes signing on, validate the controlers
function validateInputOnSignIn( %code )
{
   if( %code == 0 && getLockedControler() > -1 )
   {
      echo( "Signed in, requesting input validation" );
      ValidateControlers();
   }
}
addXBLACallback( 0, "validateInputOnSignIn", 0 ); // Login callback = 0

//-----------------------------------------------------------------------------

function onControlerRumbleRequest( %intensity )
{   
   SetControlerRumble( getLockedControler(), 0, %intensity );
   schedule( 100, 0, "turnRumbleOff", getLockedControler() );
}

function turnRumbleOff( %idx )
{
   SetControlerRumble( %idx, 0.0, 0.0 );
}

//-----------------------------------------------------------------------------
