//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
// Portions Copyright (c) 2001 by Sierra Online, Inc.
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Mission Loading & Mission Info
// The mission loading server handshaking is handled by the
// common/client/missingLoading.cs.  This portion handles the interface
// with the game GUI.
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Loading Phases:
// Phase 1: Download Datablocks
// Phase 2: Download Ghost Objects
// Phase 3: Scene Lighting
//----------------------------------------------------------------------------
// Phase 1
//----------------------------------------------------------------------------
function onMissionDownloadPhase1(%missionName, %musicTrack)
{
   // Close and clear the message hud (in case it's open)
   //MessageHud.close();
   //cls();
   // Reset the loading progress controls:
   //LoadingProgress.setValue(0);
   
   loadingGui.setLoadingText( $Text::Loading @ ".  " );
   Canvas.repaint();
   
   $LoadingDone = false;
}
function onPhase1Progress(%progress)
{
   //LoadingProgress.setValue(%progress * 0.6);
   //Canvas.repaint();
}
function onPhase1Complete()
{
}
//----------------------------------------------------------------------------
// Phase 2
//----------------------------------------------------------------------------
function onMissionDownloadPhase2()
{
   // Reset the loading progress controls:
   //LoadingProgress.setValue(0.6);
   loadingGui.setLoadingText( $Text::Loading @ ".. " );
   Canvas.repaint();
}
function onPhase2Progress(%progress)
{
   //LoadingProgress.setValue(%progress * 0.4 + 0.6);
   //Canvas.repaint();
}
function onPhase2Complete()
{
}   
//----------------------------------------------------------------------------
// Phase 3
//----------------------------------------------------------------------------
function onMissionDownloadPhase3()
{
   loadingGui.setLoadingText( $Text::Loading @ "..." );
   Canvas.repaint();
}
function onPhase3Progress(%progress)
{
   //LoadingProgress.setValue(%progress);
   //Canvas.repaint();
}
function onPhase3Complete()
{
   //LoadingProgress.setValue( 1 );
   $lightingMission = false;
}
//----------------------------------------------------------------------------
// Mission loading done!
//----------------------------------------------------------------------------
function onMissionDownloadComplete()
{
   // Client will shortly be dropped into the game, so this is
   // good place for any last minute gui cleanup.
   
   // Do this a bit later
   //$LoadingDone = true;
}

//------------------------------------------------------------------------------
// Before downloading a mission, the server transmits the mission
// information through these messages.
//------------------------------------------------------------------------------
addMessageCallback( 'MsgLoadInfo', handleLoadInfoMessage );
addMessageCallback( 'MsgLoadDescripition', handleLoadDescriptionMessage );
addMessageCallback( 'MsgLoadInfoDone', handleLoadInfoDoneMessage );
//------------------------------------------------------------------------------
function handleLoadInfoMessage( %msgType, %msgString, %mapName ) {
	
	// Need to pop up the loading gui to display this stuff.
	Canvas.setContent("LoadingGui");
}
//------------------------------------------------------------------------------
function handleLoadDescriptionMessage( %msgType, %msgString, %line )
{
}
//------------------------------------------------------------------------------
function handleLoadInfoDoneMessage( %msgType, %msgString )
{
   // This will get called after the last description line is sent.
}

