//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Game start / end events sent from the server
//----------------------------------------------------------------------------
function clientCmdGameStart()
{
   setHudVisible( true );
   
   $TimeScaleCheatEnabled = false;
   $timeScale = 1.0;
   
   if($playingDemo)
      return;
      
   XAResetLeaderboards();
}

function setAnnoyingDemoOverlayText( %text )
{
   LCT_demo_front.setText( %text );
}

function clientCmdGameEnd()
{
   if($playingDemo)
      return;
      
   // Restore simulation time
   $timeScale = 1.0;
   
   //setAllEndTitles( "Level " @ MissionInfo.level @ ": " @ MissionInfo.name );
   setAllEndTitles( MissionInfo.name );
   
   // Check for demo and not logged in
   if( isDemoLaunch() )
   {
      setAnnoyingDemoOverlayText( $Text::NoSaveInDemo );
      reformatGameEndText();
      Canvas.pushDialog(LevelCompleteTimeGui);
   }
   else if( $TimeScaleCheatEnabled )
   {
      setAnnoyingDemoOverlayText( $Text::NoSaveTimescale );
      reformatGameEndText();
      Canvas.pushDialog(LevelCompleteTimeGui);
   }
   else
   {
      setAnnoyingDemoOverlayText( "" );
      
      if( !isLoggedOn() && !$WantsToPlayOffline )
      {
         // Tell them to log on!
         Canvas.pushDialog( LevelCompleteLogOnDemoGui );
      }
      else
      {
         reformatGameEndText();
         Canvas.pushDialog( LevelCompleteTimeGui );
      }
   }

   setHudVisible( false );
}

function setAllEndTitles( %text )
{
   LCT_title_border2.setText( "<just:center>" @ %text );
   LCT_title_border1.setText( "<just:center>" @ %text );
   LCT_title_front.setText( "<just:center>" @ %text );
   
   LCS_title_border2.setText( "<just:center>" @ %text );
   LCS_title_border1.setText( "<just:center>" @ %text );
   LCS_title_front.setText( "<just:center>" @ %text );
   
   LCL_title_border2.setText( "<just:center>" @ %text );
   LCL_title_border1.setText( "<just:center>" @ %text );
   LCL_title_front.setText( "<just:center>" @ %text );
}

function setLCTBigTime( %time )
{
   if (%time < 0)
   {
      %time = -%time;
   }
   %hundredth = mFloor((%time % 1000) / 10);
   %totalSeconds = mFloor(%time / 1000);
   %seconds = %totalSeconds % 60;
   %minutes = (%totalSeconds - %seconds) / 60;
   %secondsOne   = %seconds % 10;
   %secondsTen   = (%seconds - %secondsOne) / 10;
   %minutesOne   = %minutes % 10;
   %minutesTen   = (%minutes - %minutesOne) / 10;
   %hundredthOne = %hundredth % 10; 
   %hundredthTen = (%hundredth - %hundredthOne) / 10;
   
   LCT_min10.setBitmap( "~/client/ui/game/numbers/" @ %minutesTen );
   LCT_min01.setBitmap( "~/client/ui/game/numbers/" @ %minutesOne );
   LCT_sec10.setBitmap( "~/client/ui/game/numbers/" @ %secondsTen );
   LCT_sec01.setBitmap( "~/client/ui/game/numbers/" @ %secondsOne );
   LCT_dot10.setBitmap( "~/client/ui/game/numbers/" @ %hundredthTen );
   LCT_dot01.setBitmap( "~/client/ui/game/numbers/" @ %hundredthOne );
}

$pointArray[0] = "_point010000";
$pointArray[1] = "_point001000";
$pointArray[2] = "_point000100";
$pointArray[3] = "_point000010";
$pointArray[4] = "_point000001";

function setBigScore( %page, %score )
{
   %num[0] = mFloor( %score / 10000 );
   %num[1] = mFloor( ( %score % 10000 ) / 1000 );
   %num[2] = mFloor( ( %score % 1000 ) / 100 );
   %num[3] = mFloor( ( %score % 100 ) / 10 );
   %num[4] = %score % 10;
   
   %hide = true;
   
   for( %i = 0; %i < 5; %i++ )
   {
      if( %num[%i] > 0 || !%hide )
      {
         %hide = false; // Hide only leading 0's
         eval( %page @ $pointArray[%i] @ ".setBitmap( \"marble/client/ui/game/numbers/" @ %num[%i] @ "\" );" );
         eval( %page @ $pointArray[%i] @ ".setVisible( true );" );
      }
      else
      {
         eval( %page @ $pointArray[%i] @  ".setVisible( false );" );
      }
   }
}

// This is because there are cases which you can have a display time of 6.75 
// and a gold time can be 6.75 and you can not get it
$GoldTimeDelta = 9;

function reformatGameEndText()
{
   $Game::ScoreTime = $Game::ScoreTime - ( $Game::ScoreTime % 10 );
   
   if( isDemoLaunch() || $TimeScaleCheatEnabled )
   {
      %prevBestTimeText = "";
      %prevBestScoreText = "";
   }
   else if( isLoggedOn() )
   {
      %me = new LeaderboardEntry();
      %me.loadThisPlayer();
      
      %prevBestTime = %me.getBestTime( MissionInfo.level );
      
      if( %prevBestTime == 0 )
         %prevBestTimeText = $Text::None;
      else
         %prevBestTimeText = formatTime( %prevBestTime );
      %prevBestScore = calcRating( %prevBestTime, MissionInfo.time, MissionInfo.goldTime + $GoldTimeDelta, MissionInfo.difficulty );
      %prevBestScoreText = %prevBestScore;
   }
   else
   {
      %prevBestTime = 0;
      %prevBestScore = 0;
      %prevBestTimeText = $Text::Offline;
      %prevBestScoreText = $Text::Offline;
   }
   
   %newBestScore = calcRating( $Game::ScoreTime, MissionInfo.time, MissionInfo.goldTime + $GoldTimeDelta, MissionInfo.difficulty );
   
   // By default...
   LCT_next_white.setText( $Text::Next );
   LCT_next_black.setText( $Text::Next );
   
   // Check for new best time
   if( ( %prevBestTime > $Game::ScoreTime || %prevBestTime == 0 || %prevBestScore < %newBestScore ) && $Game::Qualified )
   {
      if( %prevBestTime > $Game::ScoreTime || %prevBestTime == 0 )
         LCT_level_complete.setText( "<just:center>" @ $Text::NewBestTime );
      else
         LCT_level_complete.setText( "<just:center>" @ $Text::LevelComplete );
      
      if( %prevBestScore < %newBestScore )
         LCS_heading.setText( "<just:center>" @ $Text::NewHighScore );
      else
         LCS_heading.setText( "<just:center>" @ $Text::LevelComplete );
      if( isDemoLaunch() )
      {
         LCT_goldtag.setVisible( false );
         LCT_column_times.setText( "" );
      }
      else if( $TimeScaleCheatEnabled )
      {
         LCT_goldtag.setVisible( true );
         LCT_column_times.setText( "<just:right>\n\n" @ $Text::TimeLimit @ ":\n" @ $Text::GoldTime @ ":" );
      }
      else
      {
         LCT_goldtag.setVisible( true );
         
         if( %prevBestTime > $Game::ScoreTime )
            LCT_column_times.setText( "<just:right>" @ $Text::OldRecord @ ":\n" @ $Text::Improvement @ ":\n" @ $Text::TimeLimit @ ":\n" @ $Text::GoldTime @ ":" );
         else if( %prevBestTime == 0 )
            LCT_column_times.setText( "<just:right>" @ $Text::OldRecord @ ":\n\n" @ $Text::TimeLimit @ ":\n" @ $Text::GoldTime @ ":" );
         else
            LCT_column_times.setText("<just:right>" @ $Text::MyRecord @ ":\n\n" @ $Text::TimeLimit @ ":\n" @ $Text::GoldTime @ ":" );
      }
      
      %improvementTime = mAbs( $Game::ScoreTime - %prevBestTime );
      %scoreImprovement = %newBestScore - %prevBestScore;
      
      if( isDemoLaunch() || $TimeScaleCheatEnabled || %prevBestTime <= $Game::ScoreTime )
         %improveTimeText = "";
      else
         %improveTimeText = formatTime( %improvementTime );
      
      if( !isDemoLaunch() )
         LCT_time_text.setText( %prevBestTimeText @ "\n" @ %improveTimeText @ "\n" @ formatTime( MissionInfo.time ) @ "\n" @ formatTime( MissionInfo.goldTime ) );
      
      // START SAVING HIGH SCORE HERE!!
      //echo( "PREVBESTSCORE: " @ %prevBestScore @ " -- NEW BEST SCORE: " @ %newBestScore );
      if( !isDemoLaunch() && !$TimeScaleCheatEnabled && %prevBestScore < %newBestScore )
      {
         //echo( "SAVING SCORE..." );
         setBestTimeAndRating( MissionInfo.level, $Game::ScoreTime, %me.getRating() + %scoreImprovement );
      }
   }
   else
   {
      if( $Game::Qualified )
      {
         LCT_level_complete.setText( "<just:center>" @ $Text::LevelComplete );
         LCS_heading.setText( "<just:center>" @ $Text::LevelComplete );
      }
      else
      {
         LCT_level_complete.setText( "<just:center>" @ $Text::FailedToQualify );
         LCT_next_white.setText( $Text::Exit );
         LCT_next_black.setText( $Text::Exit );
      }
      
      if( isDemoLaunch() )
         LCT_column_times.setText( "" );
      else if( $TimeScaleCheatEnabled )
         LCT_column_times.setText( "<just:right>\n\n" @ $Text::TimeLimit @":\n" @ $Text::GoldTime @ ":" );
      else
         LCT_column_times.setText( "<just:right>" @ $Text::MyRecord @ ":\n\n" @ $Text::TimeLimit @ ":\n" @ $Text::GoldTime @ ":" );
      
      if( !isDemoLaunch() )
         LCT_time_text.setText( %prevBestTimeText @ "\n\n " @ formatTime( MissionInfo.time ) @ "\n" @ formatTime( MissionInfo.goldTime ) );
   }
   
   setLCTBigTime( $Game::ScoreTime );
   
   // LCS GUI
   if( $Game::ScoreTime <= MissionInfo.goldTime + $GoldTimeDelta )
   {
      setBigScore( "LCS", $LGG_bottom_score);
      LevelCompleteScoreGui.setGold();
   }
   else
   {
      setBigScore( "LCS", $LCS_bottom_score );
      LevelCompleteScoreGui.setNonGold();
   }
   LCS_scoretext.setText( $Text::Completion @ ":" SPC $completionBonus NL $Text::TimeBonus @ ":" SPC $timeBonus );
   LCS_difficultyMul.setText( $Text::Difficulty @ ": x" SPC MissionInfo.difficulty );
}

//-----------------------------------------------------------------------------

function calcRating( %time, %qualTime, %goldTime, %difficulty )
{
   // Mask out the lowest two digits of the times for the improvement time so that roundoff
   // doesn't make the math look wrong
   %time = %time - ( %time % 10 );
   
   if( %time > %qualTime || %time == 0 )
      return 0;
   
   $completionBonus = 1000;
   
   $timeBonus = mFloor( ( %goldTime / %time ) * 1000 );

   $LCS_bottom_score = ( $completionBonus + $timeBonus ) * %difficulty;
   %finalScore = $LCS_bottom_score;
   
   if( %time <= %goldTime )
   {
   	$LGG_bottom_score = $LCS_bottom_score * 3;
   	%finalScore = $LGG_bottom_score;
	}
   
   return %finalScore;
}

//-----------------------------------------------------------------------------

function formatTime(%time)
{
   %isNeg = "\t";
   if (%time < 0)
   {
      %time = -%time;
      %isNeg = "-\t";
   }
   
   // Hack for italian
   if( getLanguage() $= "italian" )
      %secondSeperator = ":";
   else
      %secondSeperator = ".";
   
   %hundredth = mFloor((%time % 1000) / 10);
   %totalSeconds = mFloor(%time / 1000);
   %seconds = %totalSeconds % 60;
   %minutes = (%totalSeconds - %seconds) / 60;
   %secondsOne   = %seconds % 10;
   %secondsTen   = (%seconds - %secondsOne) / 10;
   %minutesOne   = %minutes % 10;
   %minutesTen   = (%minutes - %minutesOne) / 10;
   %hundredthOne = %hundredth % 10; 
   %hundredthTen = (%hundredth - %hundredthOne) / 10;
   
   return %isNeg @ %minutesTen @ %minutesOne @ ":" @
       %secondsTen @ %secondsOne @ %secondSeperator @
       %hundredthTen @ %hundredthOne;
}
