//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
//-----------------------------------------------------------------------------
if ( isObject( moveMap ) )
   moveMap.delete();
new ActionMap(moveMap);
if ( isObject(demoMap) )
   demoMap.delete();
new ActionMap(demoMap);

// MEMORY LEAK CHECKING
//GlobalActionMap.bindCmd( joystick, button5, "", "FlagCurrentAllocs();" ); // White
//GlobalActionMap.bindCmd( joystick, button4, "", "DumpUnflaggedAllocs(fuckyou);" ); // Black

// Demo exit functionality is in guiCanvas.cc

function pauseToggle(%defaultItem)
{
   $pauseMenuCursor.menuItem = %defaultItem;
   GamePauseGui.updateCursor();
   
   if( $gamePaused )
   {
      Canvas.popDialog(GamePauseGui);
      
      // Make sure controler remove isn't up
      %doNotResume = false;
      
      for( %i = 0; %i < Canvas.getCount(); %i++ )
      {
         if( Canvas.getObject(%i) == ErrorUnplugGui.getId() ||
             Canvas.getObject(%i) == NetworkDisconnectGui.getId() )
         {
            %doNotResume = true;
         }
      }
      
      if( %doNotResume == false )
         resumeGame();
   }
   else
   {
      Canvas.pushDialog(GamePauseGui);
      pauseGame();
   }
}

moveMap.bindCmd(joystick, button8, "", "pauseToggle(0);" );
moveMap.bindCmd(joystick, button9, "", "pauseToggle(1);" );


//------------------------------------------------------------------------------
// Movement Keys
//------------------------------------------------------------------------------
$movementSpeed = 1.0; // m/s   -- Changed this to up marble speed

function setSpeed(%speed)
{
   if(%speed)
      $movementSpeed = %speed;
}

function moveXAxis(%val)
{
   $mvXAxis = %val;
}

function moveYAxis(%val)
{
   $mvYAxis = %val;
}

function moveYawAxis(%val)
{
   if( $pref::invertXCamera )
      %val *= -1.0;
   
   $mvYawAxis = %val;
}

function movePitchAxis(%val)
{
   if( $pref::invertYCamera )
      %val *= -1.0;

   $mvPitchAxis = %val;
}

function mouseFire(%val)
{
   $mvTriggerCount0++;
}

function jump(%val)
{
   $mvTriggerCount2++;
}

function mouseFire2(%val)
{
   $mvTriggerCount0++;
}

function jump2(%val)
{
   $mvTriggerCount2++;
}

function centercam(%val)
{
   $mvTriggerCount3++;
}

moveMap.bind(joystick, xaxis, moveXAxis);
moveMap.bind(joystick, yaxis, moveYAxis);
moveMap.bind(joystick, rxaxis, moveYawAxis);
moveMap.bind(joystick, ryaxis, movePitchAxis);
moveMap.bind(joystick, button6, jump);
moveMap.bind(joystick, button0, jump2);
moveMap.bind(joystick, button7, mouseFire);
moveMap.bind(joystick, button1, mouseFire2);
moveMap.bind(joystick,button2, centercam );

//------------------------------------------------------------------------------
// CHEAT BLOCK

$TimeScaleCheatState = 0;

function upTimeScale()
{
   if( $TimeScaleCheatEnabled )
   {
      $timeScale += 0.1;
      
      if( $timeScale > 3.0 )
         $timeScale = 3.0;
   }
   else
   {
      switch( $TimeScaleCheatState )
      {
         case 0:
            $TimeScaleCheatState = 1;
         case 1:
            $TimeScaleCheatState = 2;
         default:
            $TimeScaleCheatState = 0;
      }
      
   }
}

function dnTimeScale()
{
   if( $TimeScaleCheatEnabled )
   {
      $timeScale -= 0.1;
      
      if( $timeScale < 0.0 )
         $timeScale = 0.0;
   }
   else
   {
      switch( $TimeScaleCheatState )
      {
         case 2:
            $TimeScaleCheatState = 3;
         case 3:
            $TimeScaleCheatState = 4;
         default:
            $TimeScaleCheatState = 0;
      }
   }
}

function doRpovCheat()
{
   switch( $TimeScaleCheatState )
   {
      case 5:
         $TimeScaleCheatState = 6;
      case 7:
         $TimeScaleCheatState = 0;
         $TimeScaleCheatEnabled = true;
         serverPlay2d( HelpDingSfx );
         addHelpLine( $Text::TimeScaleCheatEnabled, false );
      default:
         $TimeScaleCheatState = 0;
   }
}

function doLpovCheat()
{
   switch( $TimeScaleCheatState )
   {
      case 4:
         $TimeScaleCheatState = 5;
      case 6:
         $TimeScaleCheatState = 7;
      default:
         $TimeScaleCheatState = 0;
   }
}

moveMap.bindCmd(joystick, upov, "", "upTimeScale();" );
moveMap.bindCmd(joystick, dpov, "", "dnTimeScale();" );
moveMap.bindCmd(joystick, rpov, "", "doRpovCheat();" );
moveMap.bindCmd(joystick, lpov, "", "doLpovCheat();" );

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Camera & View functions
//------------------------------------------------------------------------------
function toggleCamera(%val)
{
   if (%val && $testCheats)
      commandToServer('ToggleCamera');
}

//moveMap.bind(joystick, button3, toggleCamera);

//------------------------------------------------------------------------------
// Helper Functions
//------------------------------------------------------------------------------
function dropCameraAtPlayer(%val)
{
   if (%val && $testCheats)
      commandToServer('dropCameraAtPlayer');
}
function dropPlayerAtCamera(%val)
{
   if (%val && $testCheats)
      commandToServer('DropPlayerAtCamera');
}
//moveMap.bind(keyboard, "F8", dropCameraAtPlayer);
//moveMap.bind(keyboard, "F7", dropPlayerAtCamera);

//------------------------------------------------------------------------------
// Misc.
//------------------------------------------------------------------------------

function GAMEPAD_toggleRecordDemo()
{
   if( $doRecordDemo )
      $doRecordDemo = 0;
   else
      $doRecordDemo = 1;
}
